/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;

public class Token
implements Comparable<Token> {
    protected String id;
    protected Date expires;
    protected Tenant tenant;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Token.builder().fromToken(this);
    }

    protected Token() {
    }

    public Token(String id, Date expires, Tenant tenant) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.expires = (Date)Preconditions.checkNotNull((Object)expires, (Object)"expires");
        this.tenant = (Tenant)Preconditions.checkNotNull((Object)tenant, (Object)"tenant");
    }

    public String getId() {
        return this.id;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Token) {
            Token other = (Token)Token.class.cast(object);
            return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.expires, (Object)other.expires) && Objects.equal((Object)this.tenant, (Object)other.tenant);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.expires, this.tenant});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("expires", (Object)this.expires).add("tenant", (Object)this.tenant).toString();
    }

    @Override
    public int compareTo(Token that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public static class Builder {
        protected String id;
        protected Date expires;
        protected Tenant tenant;

        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public Builder expires(Date expires) {
            this.expires = (Date)Preconditions.checkNotNull((Object)expires, (Object)"expires");
            return this;
        }

        public Builder tenant(Tenant tenant) {
            this.tenant = (Tenant)Preconditions.checkNotNull((Object)tenant, (Object)"tenant");
            return this;
        }

        public Token build() {
            return new Token(this.id, this.expires, this.tenant);
        }

        public Builder fromToken(Token from) {
            return this.id(from.getId()).expires(from.getExpires()).tenant(from.getTenant());
        }
    }
}

