/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.domain.Role;

public class User
implements Comparable<User> {
    protected String id;
    protected String name;
    protected Set<Role> roles = ImmutableSet.of();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return User.builder().fromUser(this);
    }

    protected User() {
    }

    protected User(String id, String name, Set<Role> roles) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.roles = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(roles, (Object)"roles")));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof User) {
            User other = (User)User.class.cast(object);
            return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.roles, other.roles);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.roles});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("roles", this.roles).toString();
    }

    @Override
    public int compareTo(User that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public static class Builder {
        protected String id;
        protected String name;
        protected Set<Role> roles = ImmutableSet.of();

        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder roles(Role ... roles) {
            return this.roles((Set<Role>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)roles, (Object)"roles"))));
        }

        public Builder roles(Set<Role> roles) {
            this.roles = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(roles, (Object)"roles")));
            return this;
        }

        public User build() {
            return new User(this.id, this.name, this.roles);
        }

        public Builder fromUser(User from) {
            return this.id(from.getId()).name(from.getName()).roles(from.getRoles());
        }
    }
}

