/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.strategy.impl.ReturnCredentialsBoundToImage;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;

@Singleton
public class ParseVAppTemplateDescriptionToGetDefaultLoginCredentials
extends ReturnCredentialsBoundToImage {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    public static final Pattern USER_PASSWORD_PATTERN = Pattern.compile(".*[Uu]sername: ([a-z]+) ?.*\n[Pp]assword: ([^ \n\r]+) ?\r?\n.*");

    @Inject
    public ParseVAppTemplateDescriptionToGetDefaultLoginCredentials(@Nullable @Named(value="image") LoginCredentials creds, Map<String, Credentials> credentialStore) {
        super(creds, credentialStore);
    }

    public LoginCredentials apply(Object resourceToAuthenticate) {
        String search;
        if (this.creds != null) {
            return this.creds;
        }
        Preconditions.checkNotNull((Object)resourceToAuthenticate);
        Preconditions.checkArgument((boolean)(resourceToAuthenticate instanceof VAppTemplate), (Object)"Resource must be an VAppTemplate (for Terremark)");
        VAppTemplate template = (VAppTemplate)resourceToAuthenticate;
        String string = search = template.getDescription() != null ? template.getDescription() : template.getName();
        if (search.indexOf("Windows") >= 0) {
            return LoginCredentials.builder().user("Administrator").build();
        }
        Matcher matcher = USER_PASSWORD_PATTERN.matcher(search);
        if (matcher.find()) {
            return LoginCredentials.builder().user(matcher.group(1)).password(matcher.group(2)).authenticateSudo(true).build();
        }
        this.logger.warn("could not parse username/password for image: " + template.getHref() + "\n" + search, new Object[0]);
        return null;
    }
}

