/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgAndVDCToLocationSupplier
extends JustProvider {
    private final Supplier<Map<String, ReferenceType>> orgNameToResource;
    private final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgNameToVDCResource;
    private final Map<String, Set<String>> isoCodesById;

    @Inject
    OrgAndVDCToLocationSupplier(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider URI endpoint, @Org Supplier<Map<String, ReferenceType>> orgNameToResource, Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgNameToVDCResource, @Iso3166 Map<String, Set<String>> isoCodesById) {
        super(providerName, endpoint, isoCodes);
        this.orgNameToResource = (Supplier)Preconditions.checkNotNull(orgNameToResource, (Object)"orgNameToResource");
        this.orgNameToVDCResource = (Supplier)Preconditions.checkNotNull(orgNameToVDCResource, (Object)"orgNameToVDCResource");
        this.isoCodesById = (Map)Preconditions.checkNotNull(isoCodesById, (Object)"isoCodesById");
    }

    public Set<? extends Location> get() {
        return this.buildJustProviderOrVDCs().build();
    }

    protected ImmutableSet.Builder<Location> buildJustProviderOrVDCs() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement((Iterable)super.get());
        if (((Map)this.orgNameToResource.get()).size() == 0) {
            return locations.add((Object)provider);
        }
        for (ReferenceType org : ((Map)this.orgNameToResource.get()).values()) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.REGION).id(org.getHref().toASCIIString()).description(org.getName()).parent(provider);
            if (this.isoCodesById.containsKey(org.getHref().toASCIIString())) {
                builder.iso3166Codes((Iterable)this.isoCodesById.get(org.getHref().toASCIIString()));
            }
            Location orgL = builder.build();
            for (ReferenceType vdc : ((org.jclouds.trmk.vcloud_0_8.domain.Org)((Map)this.orgNameToVDCResource.get()).get(org.getName())).getVDCs().values()) {
                builder = new LocationBuilder().scope(LocationScope.ZONE).id(vdc.getHref().toASCIIString()).description(vdc.getName()).parent(orgL);
                if (this.isoCodesById.containsKey(vdc.getHref().toASCIIString())) {
                    builder.iso3166Codes((Iterable)this.isoCodesById.get(vdc.getHref().toASCIIString()));
                }
                locations.add((Object)builder.build());
            }
        }
        return locations;
    }
}

