/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, ReferenceType>> orgNameToEndpointSupplier;
    private final ReferenceType defaultOrg;

    @Inject
    public OrgNameToEndpoint(@Org Supplier<Map<String, ReferenceType>> orgNameToEndpointSupplier, @Org ReferenceType defaultOrg) {
        this.orgNameToEndpointSupplier = orgNameToEndpointSupplier;
        this.defaultOrg = defaultOrg;
    }

    public URI apply(Object from) {
        try {
            Map orgNameToEndpoint = (Map)this.orgNameToEndpointSupplier.get();
            return from == null ? this.defaultOrg.getHref() : ((ReferenceType)orgNameToEndpoint.get(from)).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException("org " + from + " not found in " + ((Map)this.orgNameToEndpointSupplier.get()).keySet());
        }
    }
}

