/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.OrgImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OrgHandler
extends ParseSax.HandlerWithResult<Org> {
    private StringBuilder currentText = new StringBuilder();
    protected ReferenceType org;
    protected Map<String, ReferenceType> vdcs = Maps.newLinkedHashMap();
    protected Map<String, ReferenceType> catalogs = Maps.newLinkedHashMap();
    protected Map<String, ReferenceType> tasksLists = Maps.newLinkedHashMap();
    protected ReferenceType keys;
    protected String description;

    public Org getResult() {
        return new OrgImpl(this.org.getName(), this.org.getType(), this.org.getHref(), this.description, this.catalogs, this.vdcs, this.tasksLists, this.keys);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        String type;
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.endsWith("Org")) {
            this.org = Utils.newReferenceType(attributes);
        } else if (qName.endsWith("Link") && (type = (String)attributes.get("type")) != null) {
            if (type.indexOf("vdc+xml") != -1) {
                Utils.putReferenceType(this.vdcs, attributes);
            } else if (type.indexOf("catalog+xml") != -1) {
                Utils.putReferenceType(this.catalogs, attributes);
            } else if (type.indexOf("tasksList+xml") != -1) {
                Utils.putReferenceType(this.tasksLists, attributes);
            } else if (type != null && type.endsWith("keysList+xml")) {
                this.keys = Utils.newReferenceType(attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.endsWith("Description")) {
            this.description = this.currentOrNull();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

