/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.Org;

@Singleton
public class VCloudImageSupplier
implements Supplier<Set<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final Supplier<Map<String, ? extends Org>> orgMap;
    private final Function<Org, Iterable<? extends Image>> imagesInOrg;
    private final ExecutorService executor;

    @Inject
    VCloudImageSupplier(Supplier<Map<String, ? extends Org>> orgMap, Function<Org, Iterable<? extends Image>> imagesInOrg, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.orgMap = (Supplier)Preconditions.checkNotNull(orgMap, (Object)"orgMap");
        this.imagesInOrg = (Function)Preconditions.checkNotNull(imagesInOrg, (Object)"imagesInOrg");
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    public Set<? extends Image> get() {
        Iterable orgs = (Iterable)Preconditions.checkNotNull(((Map)this.orgMap.get()).values(), (Object)"orgs");
        Iterable images = FutureIterables.transformParallel((Iterable)orgs, (Function)new Function<Org, Future<? extends Iterable<? extends Image>>>(){

            public Future<Iterable<? extends Image>> apply(final Org from) {
                Preconditions.checkNotNull((Object)from, (Object)"org");
                return VCloudImageSupplier.this.executor.submit(new Callable<Iterable<? extends Image>>(){

                    @Override
                    public Iterable<? extends Image> call() throws Exception {
                        return (Iterable)VCloudImageSupplier.this.imagesInOrg.apply((Object)from);
                    }

                    public String toString() {
                        return "imagesInOrg(" + from.getHref() + ")";
                    }
                });
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("images in " + orgs));
        return Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)images));
    }
}

