/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.trmk.vcloud_0_8.config.DefaultCatalogForOrg;
import org.jclouds.trmk.vcloud_0_8.config.DefaultNetworkForVDC;
import org.jclouds.trmk.vcloud_0_8.config.DefaultOrgForUser;
import org.jclouds.trmk.vcloud_0_8.config.DefaultTasksListForOrg;
import org.jclouds.trmk.vcloud_0_8.config.DefaultVDCForOrg;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Network;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.TasksList;
import org.jclouds.trmk.vcloud_0_8.endpoints.VDC;

public class DefaultVCloudReferencesModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Org
    @Singleton
    protected Supplier<ReferenceType> provideDefaultOrg(DefaultOrgForUser defaultOrgURIForUser, @Identity String user) {
        return defaultOrgURIForUser.apply(user);
    }

    @Provides
    @Singleton
    @Org
    protected Predicate<ReferenceType> provideDefaultOrgSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @TasksList
    @Singleton
    protected Supplier<ReferenceType> provideDefaultTasksList(DefaultTasksListForOrg defaultTasksListURIForOrg, @Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers.compose((Function)defaultTasksListURIForOrg, defaultOrg);
    }

    @Provides
    @Singleton
    @TasksList
    protected Predicate<ReferenceType> provideDefaultTasksListSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @org.jclouds.trmk.vcloud_0_8.endpoints.Catalog
    @Singleton
    protected Supplier<ReferenceType> provideDefaultCatalog(DefaultCatalogForOrg defaultCatalogURIForOrg, @Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers.compose((Function)defaultCatalogURIForOrg, defaultOrg);
    }

    @Provides
    @Singleton
    @org.jclouds.trmk.vcloud_0_8.endpoints.Catalog
    protected Predicate<ReferenceType> provideDefaultCatalogSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @Singleton
    protected Supplier<Map<URI, ? extends Catalog>> provideCatalogsById(Supplier<Map<String, Map<String, ? extends Catalog>>> supplier) {
        return Suppliers.compose((Function)new Function<Map<String, Map<String, ? extends Catalog>>, Map<URI, ? extends Catalog>>(){

            public Map<URI, ? extends Catalog> apply(Map<String, Map<String, ? extends Catalog>> arg0) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map<String, ? extends Catalog> v1 : arg0.values()) {
                    for (Catalog catalog : v1.values()) {
                        builder.put((Object)catalog.getHref(), (Object)catalog);
                    }
                }
                return builder.build();
            }
        }, supplier);
    }

    @Provides
    @VDC
    @Singleton
    protected Supplier<ReferenceType> provideDefaultVDC(DefaultVDCForOrg defaultVDCURIForOrg, @Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers.compose((Function)defaultVDCURIForOrg, defaultOrg);
    }

    @Provides
    @Singleton
    @VDC
    protected Predicate<ReferenceType> provideDefaultVDCSelector(Injector i) {
        return Predicates.alwaysTrue();
    }

    @Provides
    @Network
    @Singleton
    protected Supplier<ReferenceType> provideDefaultNetwork(DefaultNetworkForVDC defaultNetworkURIForVDC, @VDC Supplier<ReferenceType> defaultVDC) {
        return Suppliers.compose((Function)defaultNetworkURIForVDC, defaultVDC);
    }

    @Provides
    @Singleton
    @Network
    protected Predicate<ReferenceType> provideDefaultNetworkSelector(Injector i) {
        return Predicates.alwaysTrue();
    }
}

