/**
 * Licensed to jclouds, Inc. (jclouds) under one or more
 * contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  jclouds licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import static com.google.common.base.Preconditions.checkNotNull;

import java.net.URI;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;

import com.google.common.base.Function;

/**
 * @author Adrian Cole
 */
@Singleton
public class TerremarkVCloudGetNodeMetadataStrategy implements GetNodeMetadataStrategy {

   protected final TerremarkVCloudClient client;
   protected final Function<VApp, NodeMetadata> vAppToNodeMetadata;

   @Inject
   protected TerremarkVCloudGetNodeMetadataStrategy(TerremarkVCloudClient client,
         Function<VApp, NodeMetadata> vAppToNodeMetadata) {
      this.client = checkNotNull(client, "client");
      this.vAppToNodeMetadata = vAppToNodeMetadata;
   }

   public NodeMetadata getNode(String in) {
      URI id = URI.create(in);
      VApp from = client.getVApp(id);
      if (from == null)
         return null;
      return vAppToNodeMetadata.apply(from);
   }

}