/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.predicates;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.Task;
import org.jclouds.trmk.vcloud_0_8.domain.TaskStatus;

@Singleton
public class TaskSuccess
implements Predicate<URI> {
    private final TerremarkVCloudClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public TaskSuccess(TerremarkVCloudClient client) {
        this.client = client;
    }

    public boolean apply(URI taskId) {
        this.logger.trace("looking for status on task %s", new Object[]{taskId});
        Task task = this.client.getTask(taskId);
        if (task == null) {
            return false;
        }
        this.logger.trace("%s: looking for status %s: currently: %s", new Object[]{task, TaskStatus.SUCCESS, task.getStatus()});
        if (task.getStatus() == TaskStatus.ERROR) {
            throw new RuntimeException("error on task: " + task.getHref() + " error: " + task.getError());
        }
        return task.getStatus() == TaskStatus.SUCCESS;
    }
}

