/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Preconditions;
import java.net.URI;

public class NetworkExtendedInfo
implements Comparable<NetworkExtendedInfo> {
    private final String id;
    private final URI href;
    private final String name;
    private final String rnatAddress;
    private final String address;
    private final String broadcastAddress;
    private final String gatewayAddress;
    private final Type networkType;
    private final String vlan;
    private final String friendlyName;

    public NetworkExtendedInfo(String id, URI href, String name, String rnatAddress, String address, String broadcastAddress, String gatewayAddress, Type networkType, String vlan, String friendlyName) {
        this.id = id;
        this.href = href;
        this.name = name;
        this.rnatAddress = rnatAddress;
        this.address = address;
        this.broadcastAddress = broadcastAddress;
        this.gatewayAddress = gatewayAddress;
        this.networkType = networkType;
        this.vlan = vlan;
        this.friendlyName = friendlyName;
    }

    @Override
    public int compareTo(NetworkExtendedInfo that) {
        return this == that ? 0 : this.getHref().compareTo(that.getHref());
    }

    public String getId() {
        return this.id;
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public String getRnatAddress() {
        return this.rnatAddress;
    }

    public String getAddress() {
        return this.address;
    }

    public String getBroadcastAddress() {
        return this.broadcastAddress;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public Type getNetworkType() {
        return this.networkType;
    }

    public String getVlan() {
        return this.vlan;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.broadcastAddress == null ? 0 : this.broadcastAddress.hashCode());
        result = 31 * result + (this.friendlyName == null ? 0 : this.friendlyName.hashCode());
        result = 31 * result + (this.gatewayAddress == null ? 0 : this.gatewayAddress.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.networkType == null ? 0 : this.networkType.hashCode());
        result = 31 * result + (this.rnatAddress == null ? 0 : this.rnatAddress.hashCode());
        result = 31 * result + (this.vlan == null ? 0 : this.vlan.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkExtendedInfo other = (NetworkExtendedInfo)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.broadcastAddress == null ? other.broadcastAddress != null : !this.broadcastAddress.equals(other.broadcastAddress)) {
            return false;
        }
        if (this.friendlyName == null ? other.friendlyName != null : !this.friendlyName.equals(other.friendlyName)) {
            return false;
        }
        if (this.gatewayAddress == null ? other.gatewayAddress != null : !this.gatewayAddress.equals(other.gatewayAddress)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.networkType == null ? other.networkType != null : !this.networkType.equals((Object)other.networkType)) {
            return false;
        }
        if (this.rnatAddress == null ? other.rnatAddress != null : !this.rnatAddress.equals(other.rnatAddress)) {
            return false;
        }
        return !(this.vlan == null ? other.vlan != null : !this.vlan.equals(other.vlan));
    }

    public String toString() {
        return "[address=" + this.address + ", broadcastAddress=" + this.broadcastAddress + ", friendlyName=" + this.friendlyName + ", gatewayAddress=" + this.gatewayAddress + ", href=" + this.href + ", id=" + this.id + ", name=" + this.name + ", networkType=" + (Object)((Object)this.networkType) + ", rnatAddress=" + this.rnatAddress + ", vlan=" + this.vlan + "]";
    }

    public static enum Type {
        INTERNAL,
        DMZ,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf(((String)Preconditions.checkNotNull((Object)type, (Object)"type")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

