/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Catalog;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgNameAndCatalogNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultCatalog;

    @Inject
    public OrgNameAndCatalogNameToEndpoint(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap, @Org Supplier<ReferenceType> defaultOrg, @Catalog Supplier<ReferenceType> defaultCatalog) {
        this.orgMap = orgMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    public URI apply(Object from) {
        Iterable orgCatalog = (Iterable)Preconditions.checkNotNull((Object)from, (Object)"args");
        Object org = Iterables.get((Iterable)orgCatalog, (int)0);
        Object catalog = Iterables.get((Iterable)orgCatalog, (int)1);
        if (org == null && catalog == null) {
            return ((ReferenceType)this.defaultCatalog.get()).getHref();
        }
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        try {
            Map<String, ReferenceType> catalogs = ((org.jclouds.trmk.vcloud_0_8.domain.Org)Preconditions.checkNotNull(((Map)this.orgMap.get()).get(org))).getCatalogs();
            return catalog == null ? ((ReferenceType)Iterables.getLast(catalogs.values())).getHref() : catalogs.get(catalog).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + catalog + " not found in " + this.orgMap.get());
        }
    }
}

