/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.util.Strings2;

@Singleton
public class BindCreateKeyToXmlPayload
implements MapBinder {
    private final String xmlTemplate;
    private final BindToStringPayload stringBinder;
    private final String ns;

    @Inject
    BindCreateKeyToXmlPayload(@Named(value="jclouds.terremark.extension.ns") String ns, @Named(value="CreateKey") String xmlTemplate, BindToStringPayload stringBinder) {
        this.ns = ns;
        this.xmlTemplate = xmlTemplate;
        this.stringBinder = stringBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        String name = Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present").toString();
        String isDefault = Preconditions.checkNotNull((Object)postParams.get("isDefault"), (Object)"isDefault parameter not present").toString();
        String payload = Strings2.replaceTokens((String)this.xmlTemplate, (Map)ImmutableMap.of((Object)"name", (Object)name, (Object)"isDefault", (Object)isDefault, (Object)"ns", (Object)this.ns));
        return (R)this.stringBinder.bindToRequest(request, (Object)payload);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CreateKey needs parameters");
    }
}

