/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.ComputePoolReference;
import org.jclouds.trmk.vcloud_0_8.domain.NetworkAdapter;
import org.jclouds.trmk.vcloud_0_8.domain.Subnet;
import org.jclouds.trmk.vcloud_0_8.domain.VAppExtendedInfo;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VAppExtendedInfoHandler
extends ParseSax.HandlerWithResult<VAppExtendedInfo> {
    private StringBuilder currentText = new StringBuilder();
    private VAppExtendedInfo.Builder builder = VAppExtendedInfo.builder();
    private NetworkAdapter.Builder adapterBuilder = NetworkAdapter.builder();
    private Subnet.Builder subnetBuilder = Subnet.builder();
    private ComputePoolReference.Builder poolBuilder = ComputePoolReference.builder();
    private boolean inAdapters;
    private boolean inSubnet;
    private boolean inComputePool;

    public VAppExtendedInfo getResult() {
        return this.builder.build();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("NetworkAdapters")) {
            this.inAdapters = true;
        } else if (qName.equals("Subnet")) {
            this.inSubnet = true;
        } else if (qName.equals("ComputePoolReference")) {
            this.inComputePool = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        String current = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        if (current != null) {
            if (qName.equals("Id")) {
                this.builder.id(current);
            } else if (qName.equals("Tags")) {
                this.builder.tags((List<String>)ImmutableList.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)current)));
            } else if (qName.equals("LongName")) {
                this.builder.longName(current);
            } else if (qName.equals("Href")) {
                URI href = URI.create(current);
                if (this.inSubnet) {
                    this.subnetBuilder.href(href);
                } else if (this.inComputePool) {
                    this.poolBuilder.href(href);
                } else {
                    this.builder.href(href);
                }
            } else if (qName.equals("Name")) {
                if (this.inSubnet) {
                    this.subnetBuilder.name(current);
                } else if (this.inAdapters) {
                    this.adapterBuilder.name(current);
                } else if (this.inComputePool) {
                    this.poolBuilder.name(current);
                } else {
                    this.builder.name(current);
                }
            } else if (qName.equals("MacAddress")) {
                this.adapterBuilder.macAddress(current);
            }
        } else if (qName.equals("NetworkAdapters")) {
            this.inAdapters = false;
        } else if (qName.equals("NetworkAdapter")) {
            this.builder.networkAdapter(this.adapterBuilder.build());
            this.adapterBuilder = NetworkAdapter.builder();
        } else if (qName.equals("Subnet")) {
            this.adapterBuilder.subnet(this.subnetBuilder.build());
            this.subnetBuilder = Subnet.builder();
            this.inSubnet = false;
        } else if (qName.equals("ComputePoolReference")) {
            this.builder.computePoolReference(this.poolBuilder.build());
            this.poolBuilder = ComputePoolReference.builder();
            this.inComputePool = false;
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

