/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.endpoints.Network;
import org.jclouds.trmk.vcloud_0_8.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultNetworkForVDC
implements Function<ReferenceType, ReferenceType> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<Map<URI, ? extends VDC>> uriToVDC;

    @Inject
    public DefaultNetworkForVDC(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @Network Predicate<ReferenceType> defaultSelector, Supplier<Map<URI, ? extends VDC>> uriToVDC) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault((ValueOfConfigurationKeyOrNull)Preconditions.checkNotNull((Object)valueOfConfigurationKeyOrNull, (Object)"valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.network", (Predicate<ReferenceType>)((Predicate)Preconditions.checkNotNull(defaultSelector, (Object)"defaultSelector")));
        this.uriToVDC = (Supplier)Preconditions.checkNotNull(uriToVDC, (Object)"uriToVDC");
    }

    public ReferenceType apply(ReferenceType defaultVDC) {
        VDC vDC = (VDC)((Map)this.uriToVDC.get()).get(defaultVDC.getHref());
        Preconditions.checkState((vDC != null ? 1 : 0) != 0, (String)"could not retrieve VDC at %s", (Object[])new Object[]{defaultVDC});
        return this.selector.apply(vDC.getAvailableNetworks().values());
    }
}

