/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.vcloud_0_8.options.CloneVAppOptions;

@Singleton
public class BindCloneVAppParamsToXmlPayload
implements MapBinder {
    protected final String ns;
    protected final String schema;
    private final BindToStringPayload stringBinder;

    @Inject
    public BindCloneVAppParamsToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.ns = ns;
        this.schema = schema;
        this.stringBinder = stringBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState((gRequest.getArgs() != null ? 1 : 0) != 0, (Object)"args should be initialized at this point");
        String newName = Preconditions.checkNotNull((Object)postParams.remove("newName"), (Object)"newName").toString();
        String vApp = Preconditions.checkNotNull((Object)postParams.remove("vApp"), (Object)"vApp").toString();
        CloneVAppOptions options = this.findOptionsInArgsOrNull(gRequest);
        if (options == null) {
            options = new CloneVAppOptions();
        }
        try {
            return (R)this.stringBinder.bindToRequest(request, (Object)this.generateXml(newName, vApp, options));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected XMLBuilder buildRoot(String name, boolean deploy, boolean powerOn) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create((String)"CloneVAppParams").a("name", name).a("deploy", deploy + "").a("powerOn", powerOn + "").a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xsi:schemaLocation", this.ns + " " + this.schema);
        return rootBuilder;
    }

    protected String generateXml(String newName, String vApp, CloneVAppOptions options) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = this.buildRoot(newName, options.isDeploy(), options.isPowerOn());
        if (options.getDescription() != null) {
            rootBuilder.e("Description").text(options.getDescription());
        }
        rootBuilder.e("VApp").a("xmlns", this.ns).a("href", vApp).a("type", "application/vnd.vmware.vcloud.vApp+xml");
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    protected CloneVAppOptions findOptionsInArgsOrNull(GeneratedHttpRequest gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof CloneVAppOptions) {
                return (CloneVAppOptions)arg;
            }
            if (!(arg instanceof CloneVAppOptions[])) continue;
            CloneVAppOptions[] options = (CloneVAppOptions[])arg;
            return options.length > 0 ? options[0] : null;
        }
        return null;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CloneVAppParams is needs parameters");
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : (String)Preconditions.checkNotNull((Object)defaultValue, (Object)"defaultValue");
    }
}

