/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;

@Singleton
public class AllCatalogItemsInCatalog
implements Function<Catalog, Iterable<? extends CatalogItem>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    AllCatalogItemsInCatalog(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    public Iterable<? extends CatalogItem> apply(Catalog from) {
        Iterable catalogItems = FutureIterables.transformParallel((Iterable)Iterables.filter(from.values(), (Predicate)new Predicate<ReferenceType>(){

            public boolean apply(ReferenceType input) {
                return input.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml");
            }
        }), (Function)new Function<ReferenceType, Future<? extends CatalogItem>>(){

            public Future<CatalogItem> apply(ReferenceType from) {
                return AllCatalogItemsInCatalog.this.aclient.getCatalogItem(from.getHref());
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("catalogItems in " + from.getHref()));
        return catalogItems;
    }
}

