/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.CatalogImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CatalogHandler
extends ParseSax.HandlerWithResult<Catalog> {
    private StringBuilder currentText = new StringBuilder();
    private ReferenceType catalog;
    private Map<String, ReferenceType> contents = Maps.newLinkedHashMap();
    private String description;

    public Catalog getResult() {
        return new CatalogImpl(this.catalog.getName(), this.catalog.getType(), this.catalog.getHref(), this.description, this.contents);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.equals("Catalog")) {
            this.catalog = Utils.newReferenceType(attributes, "application/vnd.vmware.vcloud.catalog+xml");
        } else if (qName.equals("CatalogItem")) {
            Utils.putReferenceType(this.contents, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Description")) {
            this.description = this.currentOrNull();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

