/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.strategy.EC2DestroyNodeStrategy;

@Singleton
public class AWSEC2DestroyNodeStrategy
extends EC2DestroyNodeStrategy {
    protected final AWSEC2Client client;
    protected final Map<String, Credentials> credentialStore;

    @Inject
    protected AWSEC2DestroyNodeStrategy(AWSEC2Client client, GetNodeMetadataStrategy getNode, Map<String, Credentials> credentialStore) {
        super((EC2Client)client, getNode);
        this.client = (AWSEC2Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
    }

    protected void destroyInstanceInRegion(String region, String id) {
        String spotId = id;
        if (id.indexOf("sir-") != 0) {
            try {
                spotId = ((AWSRunningInstance)((Object)Iterables.getOnlyElement((Iterable)Iterables.concat(this.client.getInstanceServices().describeInstancesInRegion(region, id))))).getSpotInstanceRequestId();
                this.credentialStore.remove("node#" + region + "/" + spotId);
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            super.destroyInstanceInRegion(region, id);
        } else {
            this.client.getSpotInstanceServices().cancelSpotInstanceRequestsInRegion(region, spotId);
            this.credentialStore.remove("node#" + region + "/" + id);
        }
    }
}

