/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import org.jclouds.aws.ec2.util.TagFilters;

public class Tag
implements Comparable<Tag> {
    private final String resourceId;
    private final TagFilters.ResourceType resourceType;
    private final String key;
    private final String value;

    public static Builder builder() {
        return new Builder();
    }

    public Tag(String resourceId, TagFilters.ResourceType resourceType, String key, String value) {
        this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId");
        this.resourceType = (TagFilters.ResourceType)((Object)Preconditions.checkNotNull((Object)((Object)resourceType), (Object)"resourceType"));
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public TagFilters.ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Tag t) {
        return ComparisonChain.start().compare((Comparable)((Object)this.resourceId), (Comparable)((Object)t.resourceId)).compare((Comparable)((Object)this.resourceType), (Comparable)((Object)t.resourceType)).compare((Comparable)((Object)this.key), (Comparable)((Object)t.key)).compare((Comparable)((Object)this.value), (Comparable)((Object)t.value)).result();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resourceId, this.resourceType, this.key, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        if (this.resourceType == null ? other.resourceType != null : !this.resourceType.equals((Object)other.resourceType)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return "[resourceId=" + this.resourceId + ", resourceType=" + (Object)((Object)this.resourceType) + ", key=" + this.key + ", value=" + this.value + "]";
    }

    public static class Builder {
        private String resourceId;
        private TagFilters.ResourceType resourceType;
        private String key;
        private String value;

        public void clear() {
            this.resourceId = null;
            this.resourceType = null;
            this.key = null;
            this.value = null;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(TagFilters.ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Tag build() {
            return new Tag(this.resourceId, this.resourceType, this.key, this.value);
        }
    }
}

