/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.xml.DescribePlacementGroupsResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"2011-05-15"})
@VirtualHost
public interface PlacementGroupAsyncClient {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreatePlacementGroup"})
    public ListenableFuture<Void> createPlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @FormParam(value="Strategy") String var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Strategy"}, values={"CreatePlacementGroup", "cluster"})
    public ListenableFuture<Void> createPlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeletePlacementGroup"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deletePlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribePlacementGroups"})
    @XMLResponseParser(value=DescribePlacementGroupsResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<PlacementGroup>> describePlacementGroupsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);
}

