/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class PlacementGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<PlacementGroup> {
    private StringBuilder currentText = new StringBuilder();
    @Inject
    @Region
    String defaultRegion;
    private String name;
    private String strategy = "cluster";
    private PlacementGroup.State state;

    public PlacementGroup getResult() {
        String region = AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest());
        if (region == null) {
            region = this.defaultRegion;
        }
        PlacementGroup returnVal = new PlacementGroup(region, this.name, this.strategy, this.state);
        this.name = null;
        this.strategy = "cluster";
        this.state = null;
        return returnVal;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("groupName")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equals("strategy")) {
            this.strategy = this.currentText.toString().trim();
        } else if (qName.equals("state")) {
            this.state = PlacementGroup.State.fromValue(this.currentText.toString().trim());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

