/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.aws.ec2.compute.config.ImageQuery;
import org.jclouds.aws.ec2.compute.suppliers.CallForImages;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class AWSEC2ImageSupplier
implements Supplier<Set<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Set<String> clusterComputeIds;
    private final CallForImages.Factory factory;
    private final ExecutorService executor;
    private final Supplier<Set<String>> regions;
    private final Map<String, String> queries;
    private final Iterable<String> clusterRegions;
    private final Supplier<LoadingCache<RegionAndName, ? extends Image>> cache;

    @Inject
    protected AWSEC2ImageSupplier(@Region Supplier<Set<String>> regions, @ImageQuery Map<String, String> queries, @Named(value="jclouds.ec2.cc-regions") String clusterRegions, Supplier<LoadingCache<RegionAndName, ? extends Image>> cache, CallForImages.Factory factory, @ClusterCompute Set<String> clusterComputeIds, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.factory = factory;
        this.regions = regions;
        this.queries = queries;
        this.clusterRegions = Splitter.on((char)',').split((CharSequence)clusterRegions);
        this.cache = cache;
        this.clusterComputeIds = clusterComputeIds;
        this.executor = executor;
    }

    public Set<? extends Image> get() {
        ImmutableSet parsedImages;
        ImmutableSet clusterImages;
        String amiQuery = this.queries.get("jclouds.ec2.ami-query");
        String ccAmiQuery = this.queries.get("jclouds.ec2.cc-ami-query");
        Future<Iterable<Image>> normalImages = this.images((Iterable)this.regions.get(), amiQuery, "jclouds.ec2.ami-query");
        try {
            clusterImages = ImmutableSet.copyOf(this.images(this.clusterRegions, ccAmiQuery, "jclouds.ec2.cc-ami-query").get());
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Error parsing images in query %s", new Object[]{ccAmiQuery});
            throw Throwables.propagate((Throwable)e);
        }
        Iterables.addAll(this.clusterComputeIds, (Iterable)Iterables.transform((Iterable)clusterImages, (Function)new Function<Image, String>(){

            public String apply(Image arg0) {
                return arg0.getId();
            }
        }));
        try {
            parsedImages = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)clusterImages, normalImages.get()));
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Error parsing images in query %s", new Object[]{amiQuery});
            throw Throwables.propagate((Throwable)e);
        }
        Map imageMap = ImagesToRegionAndIdMap.imagesToMap((Iterable)parsedImages);
        ((LoadingCache)this.cache.get()).invalidateAll();
        ((LoadingCache)this.cache.get()).asMap().putAll(imageMap);
        this.logger.debug("<< images(%d)", new Object[]{imageMap.size()});
        return new ForwardingSet<Image>(){

            protected Set<Image> delegate() {
                return ImmutableSet.copyOf(((LoadingCache)AWSEC2ImageSupplier.this.cache.get()).asMap().values());
            }
        };
    }

    private Future<Iterable<Image>> images(Iterable<String> regions, String query, String tag) {
        if (query == null) {
            this.logger.debug(">> no %s specified, skipping image parsing", new Object[]{tag});
            return Futures.immediateFuture((Object)ImmutableSet.of());
        }
        return this.executor.submit(this.factory.parseImagesFromRegionsUsingFilter(regions, QueryStringToMultimap.INSTANCE.apply(query)));
    }

    public static enum QueryStringToMultimap implements Function<String, Multimap<String, String>>
    {
        INSTANCE;


        public Multimap<String, String> apply(String arg0) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (String pair : Splitter.on((char)';').split((CharSequence)arg0)) {
                String[] keyValue = pair.split("=");
                if (keyValue.length == 1) {
                    builder.putAll((Object)keyValue[0], (Iterable)ImmutableSet.of());
                    continue;
                }
                builder.putAll((Object)keyValue[0], Splitter.on((char)',').split((CharSequence)keyValue[1]));
            }
            return builder.build();
        }
    }
}

