/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.functions;

import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class UploadIdFromHttpResponseViaRegex
implements Function<HttpResponse, String> {
    Pattern pattern = Pattern.compile("<UploadId>([\\S&&[^<]]+)</UploadId>");
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    UploadIdFromHttpResponseViaRegex(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    public String apply(HttpResponse response) {
        Matcher matcher;
        String value = null;
        String content = this.returnStringIf200.apply(response);
        if (content != null && (matcher = this.pattern.matcher(content)).find()) {
            value = matcher.group(1);
        }
        return value;
    }
}

