/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.compute.functions;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ParseOsFromVAppTemplateName;

@Singleton
public class TerremarkECloudParseOsFromVAppTemplateName
extends ParseOsFromVAppTemplateName {
    public static final Pattern OS_PATTERN = Pattern.compile("^-?([^ ]*) ([0-9.]+)( R[1-9])? ?.*");

    @Inject
    protected TerremarkECloudParseOsFromVAppTemplateName(Map<OsFamily, Map<String, String>> osVersionMap) {
        super(osVersionMap);
    }

    public OperatingSystem apply(String from) {
        Preconditions.checkNotNull((Object)from, (Object)"vapp template name");
        OperatingSystem.Builder builder = new OperatingSystem.Builder();
        builder.description(from);
        if (from.equals("-Windows 2003 Std. R2 SQL 2005 Std. (x64)")) {
            System.out.print(';');
        }
        builder.is64Bit(from.indexOf("64") != -1);
        from = from.replace("Red Hat Enterprise Linux", "RHEL").replace("Sun Solaris", "SOLARIS").replace(" Server", "").replace("Std. ", "");
        Matcher matcher = OS_PATTERN.matcher(from);
        if (matcher.find()) {
            OsFamily osFamily = ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)matcher.group(1));
            builder.family(osFamily);
            String version = matcher.group(3) != null ? matcher.group(2) + matcher.group(3) : matcher.group(2);
            builder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)version, (Map)this.osVersionMap));
        } else {
            OsFamily osFamily = ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)from);
            builder.family(osFamily);
        }
        return builder.build();
    }
}

