/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.suppliers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.trmk.ecloud.TerremarkECloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.domain.PublicIpAddress;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.options.AddInternetServiceOptions;
import org.jclouds.trmk.vcloud_0_8.suppliers.InternetServiceAndPublicIpAddressSupplier;

@Singleton
public class TerremarkECloudInternetServiceAndPublicIpAddressSupplier
implements InternetServiceAndPublicIpAddressSupplier {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    protected final TerremarkECloudClient client;

    @Inject
    public TerremarkECloudInternetServiceAndPublicIpAddressSupplier(TerremarkECloudClient client) {
        this.client = client;
    }

    public Map.Entry<InternetService, PublicIpAddress> getNewInternetServiceAndIp(VApp vApp, int port, Protocol protocol) {
        PublicIpAddress ip;
        InternetService is;
        block3: {
            this.logger.debug(">> creating InternetService in vDC %s:%s:%d", new Object[]{vApp.getVDC().getHref(), protocol, port});
            is = null;
            ip = null;
            try {
                ip = this.client.activatePublicIpInVDC(vApp.getVDC().getHref());
            }
            catch (InsufficientResourcesException e) {
                this.logger.warn(">> no more ip addresses available, looking for one to re-use", new Object[0]);
                Set publicIps = this.client.getPublicIpsAssociatedWithVDC(vApp.getVDC().getHref());
                for (PublicIpAddress existingIp : publicIps) {
                    Set services = this.client.getInternetServicesOnPublicIp(existingIp.getId());
                    if (services.size() != 0) continue;
                    ip = existingIp;
                    break;
                }
                if (ip != null) break block3;
                throw new InsufficientResourcesException("no more ip addresses available and existing ips all have services attached: " + publicIps, e.getCause());
            }
        }
        is = this.client.addInternetServiceToExistingIp(ip.getId(), vApp.getName() + "-" + port, protocol, port, new AddInternetServiceOptions[]{AddInternetServiceOptions.Builder.withDescription((String)String.format("port %d access to serverId: %s name: %s", port, vApp.getName(), vApp.getName()))});
        ImmutableMap result = ImmutableMap.of((Object)is, (Object)ip);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(result.entrySet());
        return entry;
    }
}

