/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.amqpool;

import javax.jms.JMSException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ra.LocalAndXATransaction;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.jencks.amqpool.PooledSession;
import org.jencks.amqpool.XaConnectionPool;

public class JcaConnectionPool
extends XaConnectionPool {
    private String name;

    public JcaConnectionPool(ActiveMQConnection connection, ObjectPoolFactory poolFactory, TransactionManager transactionManager, String name) {
        super(connection, poolFactory, transactionManager);
        this.name = name;
    }

    protected XAResource createXaResource(PooledSession session) throws JMSException {
        LocalAndXATransaction xares = new LocalAndXATransaction(session.getSession().getTransactionContext());
        if (this.name != null) {
            xares = new WrapperNamedXAResource((XAResource)xares, this.name);
        }
        return xares;
    }
}

