/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.amqpool;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;
import org.jencks.amqpool.ConnectionKey;
import org.jencks.amqpool.ConnectionPool;
import org.jencks.amqpool.PooledConnection;

public class PooledConnectionFactory
implements ConnectionFactory,
Service {
    private ConnectionFactory connectionFactory;
    private Map<ConnectionKey, LinkedList<ConnectionPool>> cache = new HashMap<ConnectionKey, LinkedList<ConnectionPool>>();
    private ObjectPoolFactory poolFactory;
    private int maximumActive = 500;
    private int maxConnections = 1;

    public PooledConnectionFactory() {
        this(new ActiveMQConnectionFactory());
    }

    public PooledConnectionFactory(String brokerURL) {
        this(new ActiveMQConnectionFactory(brokerURL));
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        ConnectionKey key = new ConnectionKey(userName, password);
        LinkedList<ConnectionPool> pools = this.cache.get(key);
        if (pools == null) {
            pools = new LinkedList();
            this.cache.put(key, pools);
        }
        ConnectionPool connection = null;
        if (pools.size() == this.maxConnections) {
            connection = pools.removeFirst();
        }
        if (connection != null && connection.expiredCheck()) {
            connection = null;
        }
        if (connection == null) {
            ActiveMQConnection delegate = this.createConnection(key);
            connection = this.createConnectionPool(delegate);
        }
        pools.add(connection);
        return new PooledConnection(connection);
    }

    protected ConnectionPool createConnectionPool(ActiveMQConnection connection) {
        return new ConnectionPool(connection, this.getPoolFactory());
    }

    protected ActiveMQConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (ActiveMQConnection)this.connectionFactory.createConnection();
        }
        return (ActiveMQConnection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    public void start() {
        try {
            this.createConnection();
        }
        catch (JMSException e) {
            IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    public void stop() throws Exception {
        for (LinkedList<ConnectionPool> pools : this.cache.values()) {
            for (ConnectionPool pool : pools) {
                pool.close();
            }
        }
    }

    public ObjectPoolFactory getPoolFactory() {
        if (this.poolFactory == null) {
            this.poolFactory = this.createPoolFactory();
        }
        return this.poolFactory;
    }

    public void setPoolFactory(ObjectPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }

    public int getMaximumActive() {
        return this.maximumActive;
    }

    public void setMaximumActive(int maximumActive) {
        this.maximumActive = maximumActive;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected ObjectPoolFactory createPoolFactory() {
        return new GenericObjectPoolFactory(null, this.maximumActive);
    }
}

