/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.AndroidExtensionsExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinAndroidPluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AndroidExtensionsSubpluginIndicator;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "addAndroidExtensionsRuntimeIfNeeded", "", "project", "apply", "kotlin-gradle-plugin"})
public final class AndroidExtensionsSubpluginIndicator
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AndroidExtensionsExtension extension = (AndroidExtensionsExtension)project.getExtensions().create("androidExtensions", AndroidExtensionsExtension.class, new Object[0]);
        extension.setEvaluatedHandler((Function1<? super AndroidExtensionsExtension, Unit>)((Function1)new Function1<AndroidExtensionsExtension, Unit>(this, project){
            final /* synthetic */ AndroidExtensionsSubpluginIndicator this$0;
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull AndroidExtensionsExtension evaluatedExtension) {
                Intrinsics.checkParameterIsNotNull((Object)evaluatedExtension, (String)"evaluatedExtension");
                if (evaluatedExtension.isExperimental()) {
                    AndroidExtensionsSubpluginIndicator.access$addAndroidExtensionsRuntimeIfNeeded(this.this$0, this.$project);
                }
            }
            {
                this.this$0 = androidExtensionsSubpluginIndicator;
                this.$project = project;
                super(1);
            }
        }));
    }

    private final void addAndroidExtensionsRuntimeIfNeeded(Project project) {
        KotlinAndroidPluginWrapper kotlinAndroidPluginWrapper = (KotlinAndroidPluginWrapper)project.getPlugins().findPlugin(KotlinAndroidPluginWrapper.class);
        if (kotlinAndroidPluginWrapper == null) {
            AndroidExtensionsSubpluginIndicator androidExtensionsSubpluginIndicator;
            AndroidExtensionsSubpluginIndicator $receiver = androidExtensionsSubpluginIndicator = this;
            project.getLogger().error("'kotlin-android' plugin should be enabled before 'kotlin-android-extensions'");
            return;
        }
        KotlinAndroidPluginWrapper kotlinPluginWrapper = kotlinAndroidPluginWrapper;
        String kotlinPluginVersion = kotlinPluginWrapper.getKotlinPluginVersion();
        project.getConfigurations().all((Action)new Action<Configuration>(project, kotlinPluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $kotlinPluginVersion;

            public final void execute(Configuration configuration) {
                String requiredConfigurationName;
                Configuration configuration2 = configuration;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
                String name = configuration2.getName();
                if (Intrinsics.areEqual((Object)name, (Object)"implementation") ^ true && Intrinsics.areEqual((Object)name, (Object)"compile") ^ true) {
                    return;
                }
                String string = KotlinPluginKt.loadAndroidPluginVersion();
                if (string == null) {
                    return;
                }
                String androidPluginVersion = string;
                String string2 = requiredConfigurationName = KotlinPluginKt.compareVersionNumbers(androidPluginVersion, "2.5") > 0 ? "implementation" : "compile";
                if (Intrinsics.areEqual((Object)name, (Object)requiredConfigurationName) ^ true) {
                    return;
                }
                configuration.getDependencies().add((Object)this.$project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-android-extensions-runtime:" + this.$kotlinPluginVersion)));
            }
            {
                this.$project = project;
                this.$kotlinPluginVersion = string;
            }
        });
    }

    public static final /* synthetic */ void access$addAndroidExtensionsRuntimeIfNeeded(AndroidExtensionsSubpluginIndicator $this, @NotNull Project project) {
        $this.addAndroidExtensionsRuntimeIfNeeded(project);
    }
}

