/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnEnv;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnPlugin;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnSetupTask;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010\u0010R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnRootExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "disableWorkspaces", "", "getDisableWorkspaces", "()Z", "setDisableWorkspaces", "(Z)V", "downloadBaseUrl", "", "getDownloadBaseUrl", "()Ljava/lang/String;", "setDownloadBaseUrl", "(Ljava/lang/String;)V", "environment", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEnv;", "getEnvironment$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEnv;", "gradleHome", "Ljava/io/File;", "kotlin.jvm.PlatformType", "installationDir", "getInstallationDir", "()Ljava/io/File;", "setInstallationDir", "(Ljava/io/File;)V", "getProject", "()Lorg/gradle/api/Project;", "useWorkspaces", "getUseWorkspaces", "version", "getVersion", "setVersion", "yarnSetupTask", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnSetupTask;", "getYarnSetupTask", "()Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnSetupTask;", "executeSetup", "", "executeSetup$kotlin_gradle_plugin", "Companion", "kotlin-gradle-plugin"})
public class YarnRootExtension {
    private final File gradleHome;
    @NotNull
    private File installationDir;
    @NotNull
    private String downloadBaseUrl;
    @NotNull
    private String version;
    private boolean disableWorkspaces;
    @NotNull
    private final Project project;
    @NotNull
    public static final String YARN = "kotlinYarn";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final File getInstallationDir() {
        return this.installationDir;
    }

    public final void setInstallationDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.installationDir = file;
    }

    @NotNull
    public final String getDownloadBaseUrl() {
        return this.downloadBaseUrl;
    }

    public final void setDownloadBaseUrl(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.downloadBaseUrl = string;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.version = string;
    }

    @NotNull
    public final YarnSetupTask getYarnSetupTask() {
        Task task2 = this.project.getTasks().getByName("kotlinYarnSetup");
        if (task2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.yarn.YarnSetupTask");
        }
        return (YarnSetupTask)task2;
    }

    public final boolean getDisableWorkspaces() {
        return this.disableWorkspaces;
    }

    public final void setDisableWorkspaces(boolean bl) {
        this.disableWorkspaces = bl;
    }

    public final boolean getUseWorkspaces() {
        return !this.disableWorkspaces;
    }

    public final void executeSetup$kotlin_gradle_plugin() {
        NodeJsRootPlugin.Companion.apply(this.project).executeSetup$kotlin_gradle_plugin();
        YarnEnv env2 = this.getEnvironment$kotlin_gradle_plugin();
        if (!env2.getHome().isDirectory()) {
            this.getYarnSetupTask().setup();
        }
    }

    @NotNull
    public final YarnEnv getEnvironment$kotlin_gradle_plugin() {
        return new YarnEnv(this.downloadBaseUrl + "/v" + this.version + "/yarn-v" + this.version + ".tar.gz", FilesKt.resolve((File)this.installationDir, (String)("yarn-v" + this.version)));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public YarnRootExtension(@NotNull Project project) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        boolean bl = Intrinsics.areEqual((Object)this.project, (Object)this.project.getRootProject());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        File file2 = gradle.getGradleUserHomeDir();
        YarnRootExtension yarnRootExtension = this;
        bl2 = false;
        bl3 = false;
        File it = file2;
        boolean bl6 = false;
        Logger logger = this.project.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Storing cached files in " + it);
        yarnRootExtension.gradleHome = file = file2;
        File file3 = this.gradleHome;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"gradleHome");
        this.installationDir = FilesKt.resolve((File)file3, (String)"yarn");
        this.downloadBaseUrl = "https://github.com/yarnpkg/yarn/releases/download";
        this.version = "1.15.2";
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnRootExtension$Companion;", "", "()V", "YARN", "", "get", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnRootExtension;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final YarnRootExtension get(@NotNull Project project) {
            Project rootProject;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project project2 = rootProject = project.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"rootProject");
            project2.getPlugins().apply(YarnPlugin.class);
            Object object = rootProject.getExtensions().getByName(YarnRootExtension.YARN);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.yarn.YarnRootExtension");
            }
            return (YarnRootExtension)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

