/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\"\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\nj\b\u0012\u0004\u0012\u00020\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/logging/GradleErrorMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "delegate", "acceptableMessageSeverity", "", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "kotlinPluginVersion", "", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Ljava/lang/String;)V", "errors", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "clear", "", "flush", "file", "Ljava/io/File;", "hasErrors", "", "report", "error", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "severity", "message", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nGradleErrorMessageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleErrorMessageCollector.kt\norg/jetbrains/kotlin/gradle/logging/GradleErrorMessageCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class GradleErrorMessageCollector
implements MessageCollector {
    @Nullable
    private final MessageCollector delegate;
    @NotNull
    private final List<CompilerMessageSeverity> acceptableMessageSeverity;
    @Nullable
    private final String kotlinPluginVersion;
    @NotNull
    private final ArrayList<String> errors;

    public GradleErrorMessageCollector(@Nullable MessageCollector delegate2, @NotNull List<? extends CompilerMessageSeverity> acceptableMessageSeverity, @Nullable String kotlinPluginVersion) {
        Intrinsics.checkNotNullParameter(acceptableMessageSeverity, (String)"acceptableMessageSeverity");
        this.delegate = delegate2;
        this.acceptableMessageSeverity = acceptableMessageSeverity;
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.errors = new ArrayList();
    }

    public /* synthetic */ GradleErrorMessageCollector(MessageCollector messageCollector, List list2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            messageCollector = null;
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.listOf((Object)CompilerMessageSeverity.EXCEPTION);
        }
        if ((n & 4) != 0) {
            string = null;
        }
        this(messageCollector, list2, string);
    }

    public void clear() {
        MessageCollector messageCollector = this.delegate;
        if (messageCollector != null) {
            messageCollector.clear();
        }
        this.errors.clear();
    }

    public final void report(@NotNull Throwable error, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.report(CompilerMessageSeverity.EXCEPTION, error.getMessage() + '\n' + ExceptionsKt.stackTraceToString((Throwable)error), location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageCollector messageCollector = this.delegate;
        if (messageCollector != null) {
            messageCollector.report(severity, message2, location);
        }
        if (this.acceptableMessageSeverity.contains(severity)) {
            ArrayList<String> arrayList = this.errors;
            synchronized (arrayList) {
                boolean bl = false;
                boolean bl2 = this.errors.add(message2);
            }
        }
    }

    public boolean hasErrors() {
        return !((Collection)this.errors).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.hasErrors()) {
            return;
        }
        file.createNewFile();
        System.out.println((Object)("Errors were stored into " + file.getAbsolutePath()));
        Closeable closeable = new FileWriter(file);
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            boolean bl = false;
            String string = this.kotlinPluginVersion;
            if (string != null) {
                String string2;
                String version2 = string2 = string;
                boolean bl2 = false;
                it.append("kotlin version: " + version2 + '\n');
            }
            for (String error : this.errors) {
                it.append("error message: " + error + "\n\n");
            }
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.clear();
    }

    public GradleErrorMessageCollector() {
        this(null, null, null, 7, null);
    }
}

