/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.GradleKpmModule;
import org.jetbrains.kotlin.project.model.KpmModuleIdentifier;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/ProjectMppDependencyProjectStructureMetadataExtractor;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyProjectStructureMetadataExtractor;", "moduleIdentifier", "Lorg/jetbrains/kotlin/project/model/KpmModuleIdentifier;", "dependencyProject", "Lorg/gradle/api/Project;", "(Lorg/jetbrains/kotlin/project/model/KpmModuleIdentifier;Lorg/gradle/api/Project;)V", "getDependencyProject", "()Lorg/gradle/api/Project;", "getModuleIdentifier", "()Lorg/jetbrains/kotlin/project/model/KpmModuleIdentifier;", "getProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nMppDependencyProjectStructureMetadataExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MppDependencyProjectStructureMetadataExtractor.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/ProjectMppDependencyProjectStructureMetadataExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n618#2,12:86\n*E\n*S KotlinDebug\n*F\n+ 1 MppDependencyProjectStructureMetadataExtractor.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/ProjectMppDependencyProjectStructureMetadataExtractor\n*L\n37#1,12:86\n*E\n"})
public final class ProjectMppDependencyProjectStructureMetadataExtractor
extends MppDependencyProjectStructureMetadataExtractor {
    @NotNull
    private final KpmModuleIdentifier moduleIdentifier;
    @NotNull
    private final Project dependencyProject;

    public ProjectMppDependencyProjectStructureMetadataExtractor(@NotNull KpmModuleIdentifier moduleIdentifier, @NotNull Project dependencyProject) {
        Intrinsics.checkNotNullParameter((Object)moduleIdentifier, (String)"moduleIdentifier");
        Intrinsics.checkNotNullParameter((Object)dependencyProject, (String)"dependencyProject");
        super(null);
        this.moduleIdentifier = moduleIdentifier;
        this.dependencyProject = dependencyProject;
    }

    @NotNull
    public final KpmModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    @NotNull
    public final Project getDependencyProject() {
        return this.dependencyProject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KotlinProjectStructureMetadata getProjectStructureMetadata() {
        KotlinProjectStructureMetadata kotlinProjectStructureMetadata;
        if (KotlinProjectExtensionKt.getTopLevelExtensionOrNull(this.dependencyProject) == null) {
            kotlinProjectStructureMetadata = null;
        } else if (KotlinProjectExtensionKt.getPm20ExtensionOrNull(this.dependencyProject) != null) {
            void var3_3;
            Iterable $this$single$iv = (Iterable)KotlinProjectExtensionKt.getPm20Extension(this.dependencyProject).getModules();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                GradleKpmModule it = (GradleKpmModule)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModuleIdentifier(), (Object)this.moduleIdentifier)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            void v1 = var3_3;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"dependencyProject.pm20Ex\u2026ier == moduleIdentifier }");
            kotlinProjectStructureMetadata = KotlinProjectStructureMetadataKt.buildProjectStructureMetadata((GradleKpmModule)v1);
        } else {
            KotlinMultiplatformExtension kotlinMultiplatformExtension = KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(this.dependencyProject);
            kotlinProjectStructureMetadata = kotlinMultiplatformExtension != null ? KotlinProjectStructureMetadataKt.getKotlinProjectStructureMetadata(kotlinMultiplatformExtension) : null;
        }
        return kotlinProjectStructureMetadata;
    }
}

