/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.configurator;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.configurator.KotlinAndroidSourceSetConfigurator;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/configurator/MultiplatformLayoutV2DefaultManifestLocationConfigurator;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/configurator/KotlinAndroidSourceSetConfigurator;", "()V", "DEFAULT_FILE_NAME", "", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "configure", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "kotlin-gradle-plugin_common"})
public final class MultiplatformLayoutV2DefaultManifestLocationConfigurator
implements KotlinAndroidSourceSetConfigurator {
    @NotNull
    public static final MultiplatformLayoutV2DefaultManifestLocationConfigurator INSTANCE = new MultiplatformLayoutV2DefaultManifestLocationConfigurator();
    @NotNull
    private static final String DEFAULT_FILE_NAME = "AndroidManifest.xml";
    private static final Logger logger = Logging.getLogger(INSTANCE.getClass());

    private MultiplatformLayoutV2DefaultManifestLocationConfigurator() {
    }

    @Override
    public void configure(@NotNull KotlinAndroidTarget target2, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        File defaultManifestLocation = target2.getProject().file((Object)("src/" + androidSourceSet.getName() + "/AndroidManifest.xml"));
        if (!Intrinsics.areEqual((Object)androidSourceSet.getManifest().getSrcFile(), (Object)defaultManifestLocation)) {
            logger.debug(StringsKt.trimIndent((String)("\n                    " + androidSourceSet.getName() + ": Default Manifest location was already changed\n                    Expected: " + defaultManifestLocation + ", Found: " + androidSourceSet.getManifest().getSrcFile() + "\n                ")));
            return;
        }
        File newManifestLocation = target2.getProject().file((Object)("src/" + kotlinSourceSet.getName() + "/AndroidManifest.xml"));
        androidSourceSet.getManifest().srcFile((Object)newManifestLocation);
        logger.debug(androidSourceSet.getName() + ": Changed default Manifest location to " + newManifestLocation);
    }

    @Override
    public void configureWithVariant(@NotNull KotlinAndroidTarget target2, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull BaseVariant variant) {
        KotlinAndroidSourceSetConfigurator.DefaultImpls.configureWithVariant(this, target2, kotlinSourceSet, variant);
    }
}

