/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.client;

import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HeaderElement;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.message.BasicHeaderElementIterator;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value2 = he.getValue();
            if (value2 == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value2) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

