/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.protocol;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriPatternMatcher<T> {
    private final Map<String, T> map = new HashMap<String, T>();

    public synchronized void register(String pattern, T obj2) {
        Args.notNull(pattern, "URI request pattern");
        this.map.put(pattern, obj2);
    }

    public synchronized void unregister(String pattern) {
        if (pattern == null) {
            return;
        }
        this.map.remove(pattern);
    }

    @Deprecated
    public synchronized void setHandlers(Map<String, T> map2) {
        Args.notNull(map2, "Map of handlers");
        this.map.clear();
        this.map.putAll(map2);
    }

    @Deprecated
    public synchronized void setObjects(Map<String, T> map2) {
        Args.notNull(map2, "Map of handlers");
        this.map.clear();
        this.map.putAll(map2);
    }

    @Deprecated
    public synchronized Map<String, T> getObjects() {
        return this.map;
    }

    public synchronized T lookup(String path) {
        Args.notNull(path, "Request path");
        T obj2 = this.map.get(path);
        if (obj2 == null) {
            String bestMatch = null;
            for (String pattern : this.map.keySet()) {
                if (!this.matchUriRequestPattern(pattern, path) || bestMatch != null && bestMatch.length() >= pattern.length() && (bestMatch.length() != pattern.length() || !pattern.endsWith("*"))) continue;
                obj2 = this.map.get(pattern);
                bestMatch = pattern;
            }
        }
        return obj2;
    }

    protected boolean matchUriRequestPattern(String pattern, String path) {
        if (pattern.equals("*")) {
            return true;
        }
        return pattern.endsWith("*") && path.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && path.endsWith(pattern.substring(1, pattern.length()));
    }

    public String toString() {
        return this.map.toString();
    }
}

