/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.tree.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String descriptor2) {
        this(589824, descriptor2);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int api, String descriptor2) {
        super(api);
        this.desc = descriptor2;
    }

    AnnotationNode(List<Object> values) {
        super(589824);
        this.values = values;
    }

    @Override
    public void visit(String name2, Object value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        if (value2 instanceof byte[]) {
            this.values.add(Util.asArrayList((byte[])value2));
        } else if (value2 instanceof boolean[]) {
            this.values.add(Util.asArrayList((boolean[])value2));
        } else if (value2 instanceof short[]) {
            this.values.add(Util.asArrayList((short[])value2));
        } else if (value2 instanceof char[]) {
            this.values.add(Util.asArrayList((char[])value2));
        } else if (value2 instanceof int[]) {
            this.values.add(Util.asArrayList((int[])value2));
        } else if (value2 instanceof long[]) {
            this.values.add(Util.asArrayList((long[])value2));
        } else if (value2 instanceof float[]) {
            this.values.add(Util.asArrayList((float[])value2));
        } else if (value2 instanceof double[]) {
            this.values.add(Util.asArrayList((double[])value2));
        } else {
            this.values.add(value2);
        }
    }

    @Override
    public void visitEnum(String name2, String descriptor2, String value2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        this.values.add(new String[]{descriptor2, value2});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name2, String descriptor2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        AnnotationNode annotation = new AnnotationNode(descriptor2);
        this.values.add(annotation);
        return annotation;
    }

    @Override
    public AnnotationVisitor visitArray(String name2) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name2);
        }
        ArrayList<Object> array2 = new ArrayList<Object>();
        this.values.add(array2);
        return new AnnotationNode(array2);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int api) {
    }

    public void accept(AnnotationVisitor annotationVisitor) {
        if (annotationVisitor != null) {
            if (this.values != null) {
                int n = this.values.size();
                for (int i2 = 0; i2 < n; i2 += 2) {
                    String name2 = (String)this.values.get(i2);
                    Object value2 = this.values.get(i2 + 1);
                    AnnotationNode.accept(annotationVisitor, name2, value2);
                }
            }
            annotationVisitor.visitEnd();
        }
    }

    static void accept(AnnotationVisitor annotationVisitor, String name2, Object value2) {
        if (annotationVisitor != null) {
            if (value2 instanceof String[]) {
                String[] typeValue = (String[])value2;
                annotationVisitor.visitEnum(name2, typeValue[0], typeValue[1]);
            } else if (value2 instanceof AnnotationNode) {
                AnnotationNode annotationValue = (AnnotationNode)value2;
                annotationValue.accept(annotationVisitor.visitAnnotation(name2, annotationValue.desc));
            } else if (value2 instanceof List) {
                AnnotationVisitor arrayAnnotationVisitor = annotationVisitor.visitArray(name2);
                if (arrayAnnotationVisitor != null) {
                    List arrayValue = (List)value2;
                    int n = arrayValue.size();
                    for (int i2 = 0; i2 < n; ++i2) {
                        AnnotationNode.accept(arrayAnnotationVisitor, null, arrayValue.get(i2));
                    }
                    arrayAnnotationVisitor.visitEnd();
                }
            } else {
                annotationVisitor.visit(name2, value2);
            }
        }
    }
}

