/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMapBuilder;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.JetType;

public class JavaToKotlinClassMap
extends JavaToKotlinClassMapBuilder
implements PlatformToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE = new JavaToKotlinClassMap();
    private final Map<FqName, ClassDescriptor> classDescriptorMap = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqName, ClassDescriptor> classDescriptorMapForCovariantPositions = new HashMap<FqName, ClassDescriptor>();
    private final Map<String, JetType> primitiveTypesMap = new LinkedHashMap<String, JetType>();
    private final Map<FqName, Collection<ClassDescriptor>> packagesWithMappedClasses = new HashMap<FqName, Collection<ClassDescriptor>>();
    private final Set<ClassDescriptor> allKotlinClasses = new LinkedHashSet<ClassDescriptor>();

    private JavaToKotlinClassMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            String name = jvmPrimitiveType.getName();
            FqName wrapperFqName = jvmPrimitiveType.getWrapperFqName();
            this.register(wrapperFqName, builtIns.getPrimitiveClassDescriptor(primitiveType));
            this.primitiveTypesMap.put(name, builtIns.getPrimitiveJetType(primitiveType));
            this.primitiveTypesMap.put("[" + name, builtIns.getPrimitiveArrayJetType(primitiveType));
            this.primitiveTypesMap.put(wrapperFqName.asString(), builtIns.getNullablePrimitiveJetType(primitiveType));
        }
        this.primitiveTypesMap.put("void", KotlinBuiltIns.getInstance().getUnitType());
        for (JetType type2 : this.primitiveTypesMap.values()) {
            this.allKotlinClasses.add((ClassDescriptor)type2.getConstructor().getDeclarationDescriptor());
        }
    }

    @Nullable
    public JetType mapPrimitiveKotlinClass(@NotNull String name) {
        return this.primitiveTypesMap.get(name);
    }

    @Nullable
    public ClassDescriptor mapKotlinClass(@NotNull FqName fqName2, @NotNull TypeUsage typeUsage) {
        ClassDescriptor descriptor2;
        if ((typeUsage == TypeUsage.MEMBER_SIGNATURE_COVARIANT || typeUsage == TypeUsage.SUPERTYPE) && (descriptor2 = this.classDescriptorMapForCovariantPositions.get(fqName2)) != null) {
            return descriptor2;
        }
        return this.classDescriptorMap.get(fqName2);
    }

    @NotNull
    private static FqName fqNameByClass(@NotNull Class<?> clazz) {
        return new FqName(clazz.getCanonicalName());
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            this.register(JavaToKotlinClassMap.fqNameByClass(javaClass), kotlinDescriptor);
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor) {
        FqName javaClassName = JavaToKotlinClassMap.fqNameByClass(javaClass);
        this.register(javaClassName, kotlinDescriptor);
        this.registerCovariant(javaClassName, kotlinMutableDescriptor);
    }

    private void register(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        this.classDescriptorMap.put(javaClassName, kotlinDescriptor);
        this.registerClassInPackage(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerCovariant(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        this.classDescriptorMapForCovariantPositions.put(javaClassName, kotlinDescriptor);
        this.registerClassInPackage(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerClassInPackage(@NotNull FqName packageFqName, @NotNull ClassDescriptor kotlinDescriptor) {
        Collection<ClassDescriptor> classesInPackage = this.packagesWithMappedClasses.get(packageFqName);
        if (classesInPackage == null) {
            classesInPackage = new HashSet<ClassDescriptor>();
            this.packagesWithMappedClasses.put(packageFqName, classesInPackage);
        }
        classesInPackage.add(kotlinDescriptor);
        this.allKotlinClasses.add(kotlinDescriptor);
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2) {
        ClassDescriptor kotlinAnalog = this.classDescriptorMap.get(fqName2);
        ClassDescriptor kotlinCovariantAnalog = this.classDescriptorMapForCovariantPositions.get(fqName2);
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>(2);
        if (kotlinAnalog != null) {
            descriptors.add(kotlinAnalog);
        }
        if (kotlinCovariantAnalog != null) {
            descriptors.add(kotlinCovariantAnalog);
        }
        return descriptors;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        FqNameUnsafe className = DescriptorUtils.getFqName(classDescriptor);
        if (!className.isSafe()) {
            return Collections.emptyList();
        }
        return this.mapPlatformClass(className.toSafe());
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClassesInside(@NotNull DeclarationDescriptor containingDeclaration) {
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
        if (!fqName2.isSafe()) {
            return Collections.emptyList();
        }
        Collection<ClassDescriptor> result = this.packagesWithMappedClasses.get(fqName2.toSafe());
        return result == null ? Collections.emptySet() : Collections.unmodifiableCollection(result);
    }

    @NotNull
    public Set<ClassDescriptor> allKotlinClasses() {
        return this.allKotlinClasses;
    }
}

