/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.DefaultAnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameBase;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.KeywordStringsGenerated;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.renderer.RendererPackage;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.JavaClassValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.MissingDependencyErrorClass;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class DescriptorRendererImpl
implements DescriptorRenderer {
    private final Function1<JetType, JetType> typeNormalizer;
    private final NameShortness nameShortness;
    private final boolean withDefinedIn;
    private final Set<DescriptorRenderer.Modifier> modifiers;
    private final boolean startFromName;
    private final boolean debugMode;
    private final boolean classWithPrimaryConstructor;
    private final boolean verbose;
    private final boolean unitReturnType;
    private final boolean normalizedVisibilities;
    private final boolean showInternalKeyword;
    private final boolean prettyFunctionTypes;
    private final boolean uninferredTypeParameterAsName;
    private final boolean includeSynthesizedParameterNames;
    private final boolean withoutFunctionParameterNames;
    private final boolean withoutTypeParameters;
    private final boolean renderCompanionObjectName;
    private final boolean withoutSuperTypes;
    private final boolean receiverAfterName;
    private final boolean renderDefaultValues;
    private final boolean flexibleTypesForCode;
    @NotNull
    private final DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy;
    @NotNull
    private final DescriptorRenderer.ValueParametersHandler handler;
    @NotNull
    private final DescriptorRenderer.TextFormat textFormat;
    private final boolean includePropertyConstant;
    private final boolean secondaryConstructorsAsPrimary;
    @NotNull
    private final Set<FqName> excludedAnnotationClasses;

    DescriptorRendererImpl(NameShortness nameShortness, boolean withDefinedIn, Set<DescriptorRenderer.Modifier> modifiers, boolean startFromName, boolean debugMode, boolean classWithPrimaryConstructor, boolean verbose, boolean unitReturnType, boolean normalizedVisibilities, boolean showInternalKeyword, boolean prettyFunctionTypes, boolean uninferredTypeParameterAsName, @NotNull DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy, @NotNull DescriptorRenderer.ValueParametersHandler handler, @NotNull DescriptorRenderer.TextFormat textFormat, @NotNull Collection<FqName> excludedAnnotationClasses, boolean includePropertyConstant, boolean includeSynthesizedParameterNames, boolean withoutFunctionParameterNames, boolean withoutTypeParameters, boolean receiverAfterName, boolean renderCompanionObjectName, boolean withoutSuperTypes, @NotNull Function1<JetType, JetType> typeNormalizer, boolean renderDefaultValues, boolean flexibleTypesForCode, boolean secondaryConstructorsAsPrimary) {
        this.nameShortness = nameShortness;
        this.withDefinedIn = withDefinedIn;
        this.modifiers = modifiers;
        this.startFromName = startFromName;
        this.handler = handler;
        this.classWithPrimaryConstructor = classWithPrimaryConstructor;
        this.verbose = verbose;
        this.unitReturnType = unitReturnType;
        this.normalizedVisibilities = normalizedVisibilities;
        this.showInternalKeyword = showInternalKeyword;
        this.overrideRenderingPolicy = overrideRenderingPolicy;
        this.debugMode = debugMode;
        this.textFormat = textFormat;
        this.includePropertyConstant = includePropertyConstant;
        this.secondaryConstructorsAsPrimary = secondaryConstructorsAsPrimary;
        this.excludedAnnotationClasses = new HashSet<FqName>(excludedAnnotationClasses);
        this.prettyFunctionTypes = prettyFunctionTypes;
        this.uninferredTypeParameterAsName = uninferredTypeParameterAsName;
        this.includeSynthesizedParameterNames = includeSynthesizedParameterNames;
        this.withoutFunctionParameterNames = withoutFunctionParameterNames;
        this.withoutTypeParameters = withoutTypeParameters;
        this.receiverAfterName = receiverAfterName;
        this.renderCompanionObjectName = renderCompanionObjectName;
        this.withoutSuperTypes = withoutSuperTypes;
        this.typeNormalizer = typeNormalizer;
        this.renderDefaultValues = renderDefaultValues;
        this.flexibleTypesForCode = flexibleTypesForCode;
    }

    @NotNull
    private String renderKeyword(@NotNull String keyword) {
        switch (this.textFormat) {
            case PLAIN: {
                return keyword;
            }
            case HTML: {
                return "<b>" + keyword + "</b>";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderError(@NotNull String keyword) {
        switch (this.textFormat) {
            case PLAIN: {
                return keyword;
            }
            case HTML: {
                return "<font color=red><b>" + keyword + "</b></font>";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String escape(@NotNull String string) {
        switch (this.textFormat) {
            case PLAIN: {
                return string;
            }
            case HTML: {
                return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String lt() {
        return this.escape("<");
    }

    @NotNull
    private String gt() {
        return this.escape(">");
    }

    @NotNull
    private String arrow() {
        switch (this.textFormat) {
            case PLAIN: {
                return this.escape("->");
            }
            case HTML: {
                return "&rarr;";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderMessage(@NotNull String message) {
        switch (this.textFormat) {
            case PLAIN: {
                return message;
            }
            case HTML: {
                return "<i>" + message + "</i>";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    private static void renderSpaceIfNeeded(@NotNull StringBuilder builder) {
        int length = builder.length();
        if (length == 0 || builder.charAt(length - 1) != ' ') {
            builder.append(' ');
        }
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name identifier) {
        String asString = identifier.asString();
        return this.escape(DescriptorRendererImpl.nameShouldBeEscaped(identifier) ? '`' + asString + '`' : asString);
    }

    private static boolean nameShouldBeEscaped(@NotNull Name identifier) {
        if (identifier.isSpecial()) {
            return false;
        }
        String name = identifier.asString();
        if (KeywordStringsGenerated.KEYWORDS.contains(name)) {
            return true;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return true;
        }
        return false;
    }

    private void renderName(@NotNull DeclarationDescriptor descriptor2, @NotNull StringBuilder builder) {
        builder.append(this.renderName(descriptor2.getName()));
    }

    private void renderCompanionObjectName(@NotNull DeclarationDescriptor descriptor2, @NotNull StringBuilder builder) {
        if (this.renderCompanionObjectName) {
            if (this.startFromName) {
                builder.append("companion object");
            }
            DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                builder.append(this.renderName(containingDeclaration.getName()));
            }
        }
        if (this.verbose) {
            if (!this.startFromName) {
                DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            }
            builder.append(this.renderName(descriptor2.getName()));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameBase fqName2) {
        return this.renderFqName(fqName2.pathSegments());
    }

    @NotNull
    private String renderFqName(@NotNull List<Name> pathSegments) {
        StringBuilder buf = new StringBuilder();
        for (Name element : pathSegments) {
            if (buf.length() != 0) {
                buf.append(".");
            }
            buf.append(this.renderName(element));
        }
        return buf.toString();
    }

    @Override
    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        if (klass instanceof MissingDependencyErrorClass) {
            return ((MissingDependencyErrorClass)((Object)klass)).getFullFqName().asString();
        }
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        switch (this.nameShortness) {
            case SHORT: {
                ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
                DeclarationDescriptor current = klass;
                do {
                    qualifiedNameElements.add(current.getName());
                } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
                Collections.reverse(qualifiedNameElements);
                return this.renderFqName(qualifiedNameElements);
            }
            case FULLY_QUALIFIED: {
                return this.renderFqName(DescriptorUtils.getFqName(klass));
            }
            case SOURCE_CODE_QUALIFIED: {
                return RendererPackage.qualifiedNameForSourceCode(klass);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    @NotNull
    public String renderType(@NotNull JetType type2) {
        return this.renderNormalizedType((JetType)this.typeNormalizer.invoke((Object)type2));
    }

    @NotNull
    private String renderNormalizedType(@NotNull JetType type2) {
        if (type2 instanceof LazyType && this.debugMode) {
            return type2.toString();
        }
        if (TypesPackage.isDynamic(type2)) {
            return "dynamic";
        }
        if (TypesPackage.isFlexible(type2)) {
            if (this.debugMode) {
                return this.renderFlexibleTypeWithBothBounds(TypesPackage.flexibility(type2).getLowerBound(), TypesPackage.flexibility(type2).getUpperBound());
            }
            if (this.flexibleTypesForCode) {
                String prefix = this.nameShortness == NameShortness.SHORT ? "" : Flexibility.FLEXIBLE_TYPE_CLASSIFIER.getPackageFqName().asString() + ".";
                return prefix + Flexibility.FLEXIBLE_TYPE_CLASSIFIER.getRelativeClassName() + this.lt() + this.renderNormalizedType(TypesPackage.flexibility(type2).getLowerBound()) + ", " + this.renderNormalizedType(TypesPackage.flexibility(type2).getUpperBound()) + this.gt();
            }
            return this.renderFlexibleType(type2);
        }
        return this.renderInflexibleType(type2);
    }

    private String renderFlexibleTypeWithBothBounds(@NotNull JetType lower, @NotNull JetType upper) {
        return "(" + this.renderNormalizedType(lower) + ".." + this.renderNormalizedType(upper) + ")";
    }

    private String renderInflexibleType(@NotNull JetType type2) {
        assert (!TypesPackage.isFlexible(type2)) : "Flexible types not allowed here: " + this.renderNormalizedType(type2);
        if (type2 == TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE || TypeUtils.isDontCarePlaceholder(type2)) {
            return "???";
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.uninferredTypeParameterAsName) {
                return this.renderError(((ErrorUtils.UninferredParameterTypeConstructor)type2.getConstructor()).getTypeParameterDescriptor().getName().toString());
            }
            return "???";
        }
        if (type2.isError()) {
            return this.renderDefaultType(type2);
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            return this.renderFunctionType(type2);
        }
        return this.renderDefaultType(type2);
    }

    private boolean shouldRenderAsPrettyFunctionType(@NotNull JetType type2) {
        return KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2) && this.prettyFunctionTypes;
    }

    @NotNull
    private String renderFlexibleType(@NotNull JetType type2) {
        String upperRendered;
        JetType lower = TypesPackage.flexibility(type2).getLowerBound();
        JetType upper = TypesPackage.flexibility(type2).getUpperBound();
        String lowerRendered = this.renderInflexibleType(lower);
        if (DescriptorRendererImpl.differsOnlyInNullability(lowerRendered, upperRendered = this.renderInflexibleType(upper))) {
            if (upperRendered.startsWith("(")) {
                return "(" + lowerRendered + ")!";
            }
            return lowerRendered + "!";
        }
        String kotlinPrefix = this.nameShortness != NameShortness.SHORT ? "kotlin." : "";
        String mutablePrefix = "Mutable";
        String simpleCollection = DescriptorRendererImpl.replacePrefixes(lowerRendered, kotlinPrefix + mutablePrefix, upperRendered, kotlinPrefix, kotlinPrefix + "(" + mutablePrefix + ")");
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = DescriptorRendererImpl.replacePrefixes(lowerRendered, kotlinPrefix + "MutableMap.MutableEntry", upperRendered, kotlinPrefix + "Map.Entry", kotlinPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        String array = DescriptorRendererImpl.replacePrefixes(lowerRendered, kotlinPrefix + this.escape("Array<"), upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            return array;
        }
        return this.renderFlexibleTypeWithBothBounds(lower, upper);
    }

    @Nullable
    private static String replacePrefixes(@NotNull String lowerRendered, @NotNull String lowerPrefix, @NotNull String upperRendered, @NotNull String upperPrefix, @NotNull String foldedPrefix) {
        String lowerWithoutPrefix;
        if (lowerRendered.startsWith(lowerPrefix) && upperRendered.startsWith(upperPrefix) && DescriptorRendererImpl.differsOnlyInNullability(lowerWithoutPrefix = lowerRendered.substring(lowerPrefix.length()), upperRendered.substring(upperPrefix.length()))) {
            return foldedPrefix + lowerWithoutPrefix + "!";
        }
        return null;
    }

    private static boolean differsOnlyInNullability(String lower, String upper) {
        return lower.equals(upper.replace("?", "")) || upper.endsWith("?") && (lower + "?").equals(upper) || ("(" + lower + ")?").equals(upper);
    }

    @Override
    @NotNull
    public String renderTypeArguments(@NotNull List<TypeProjection> typeArguments) {
        if (typeArguments.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.lt());
        this.appendTypeProjections(typeArguments, sb);
        sb.append(this.gt());
        return sb.toString();
    }

    @NotNull
    private String renderDefaultType(@NotNull JetType type2) {
        StringBuilder sb = new StringBuilder();
        if (type2.isError()) {
            sb.append(type2.getConstructor().toString());
        } else {
            sb.append(this.renderTypeName(type2.getConstructor()));
        }
        sb.append(this.renderTypeArguments(type2.getArguments()));
        if (type2.isMarkedNullable()) {
            sb.append("?");
        }
        return sb.toString();
    }

    @NotNull
    private String renderTypeName(@NotNull TypeConstructor typeConstructor2) {
        ClassifierDescriptor cd = typeConstructor2.getDeclarationDescriptor();
        if (cd instanceof TypeParameterDescriptor) {
            return this.renderName(cd.getName());
        }
        if (cd instanceof ClassDescriptor) {
            return this.renderClassifierName((ClassDescriptor)cd);
        }
        assert (cd == null) : "Unexpected classifier: " + cd.getClass();
        return typeConstructor2.toString();
    }

    private void appendTypeProjections(@NotNull List<TypeProjection> typeProjections, @NotNull StringBuilder builder) {
        Iterator<TypeProjection> iterator2 = typeProjections.iterator();
        while (iterator2.hasNext()) {
            TypeProjection typeProjection = iterator2.next();
            if (typeProjection.isStarProjection()) {
                builder.append("*");
            } else {
                if (typeProjection.getProjectionKind() != Variance.INVARIANT) {
                    builder.append((Object)typeProjection.getProjectionKind()).append(" ");
                }
                builder.append(this.renderNormalizedType(typeProjection.getType()));
            }
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    @NotNull
    private String renderFunctionType(@NotNull JetType type2) {
        StringBuilder sb = new StringBuilder();
        JetType receiverType = KotlinBuiltIns.getReceiverType(type2);
        if (receiverType != null) {
            sb.append(this.renderNormalizedType(receiverType));
            sb.append(".");
        }
        sb.append("(");
        this.appendTypeProjections(KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(type2), sb);
        sb.append(") ").append(this.arrow()).append(" ");
        sb.append(this.renderNormalizedType(KotlinBuiltIns.getReturnTypeFromFunctionType(type2)));
        if (type2.isMarkedNullable()) {
            return "(" + sb + ")?";
        }
        return sb.toString();
    }

    private void appendDefinedIn(@NotNull DeclarationDescriptor descriptor2, @NotNull StringBuilder builder) {
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return;
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        builder.append(" ").append(this.renderMessage("defined in")).append(" ");
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration != null) {
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            builder.append(FqName.ROOT.equalsTo(fqName2) ? "root package" : this.renderFqName(fqName2));
        }
    }

    private void renderAnnotations(@NotNull Annotated annotated, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.ANNOTATIONS)) {
            return;
        }
        for (AnnotationDescriptor annotation : annotated.getAnnotations()) {
            ClassDescriptor annotationClass = (ClassDescriptor)annotation.getType().getConstructor().getDeclarationDescriptor();
            assert (annotationClass != null);
            if (this.excludedAnnotationClasses.contains(DescriptorUtils.getFqNameSafe(annotationClass))) continue;
            builder.append(this.renderAnnotation(annotation)).append(" ");
        }
    }

    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.renderType(annotation.getType()));
        if (this.verbose) {
            sb.append("(").append(UtilsPackage.join(this.renderAndSortAnnotationArguments(annotation), ", ")).append(")");
        }
        return sb.toString();
    }

    @NotNull
    private List<String> renderAndSortAnnotationArguments(@NotNull AnnotationDescriptor descriptor2) {
        Set<Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>>> valueArguments = descriptor2.getAllValueArguments().entrySet();
        ArrayList<String> resultList = new ArrayList<String>(valueArguments.size());
        for (Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>> entry : valueArguments) {
            CompileTimeConstant<?> value = entry.getValue();
            String typeSuffix = ": " + this.renderType(value.getType(KotlinBuiltIns.getInstance()));
            resultList.add(entry.getKey().getName().asString() + " = " + this.renderConstant(value) + typeSuffix);
        }
        Collections.sort(resultList);
        return resultList;
    }

    @NotNull
    private String renderConstant(@NotNull CompileTimeConstant<?> value) {
        return value.accept(new DefaultAnnotationArgumentVisitor<String, Void>(){

            @Override
            public String visitValue(@NotNull CompileTimeConstant<?> value, Void data2) {
                return value.toString();
            }

            @Override
            public String visitArrayValue(ArrayValue value, Void data2) {
                List renderedElements = KotlinPackage.map((Iterable)value.getValue(), (Function1)new Function1<CompileTimeConstant<?>, String>(){

                    public String invoke(CompileTimeConstant<?> constant) {
                        return DescriptorRendererImpl.this.renderConstant(constant);
                    }
                });
                return "{" + UtilsPackage.join(renderedElements, ", ") + "}";
            }

            @Override
            public String visitAnnotationValue(AnnotationValue value, Void data2) {
                return DescriptorRendererImpl.this.renderAnnotation(value.getValue());
            }

            @Override
            public String visitJavaClassValue(JavaClassValue value, Void data2) {
                return DescriptorRendererImpl.this.renderType(value.getValue()) + ".class";
            }
        }, null);
    }

    private void renderVisibility(@NotNull Visibility visibility, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.VISIBILITY)) {
            return;
        }
        if (this.normalizedVisibilities) {
            visibility = visibility.normalize();
        }
        if (!this.showInternalKeyword && visibility == Visibilities.INTERNAL) {
            return;
        }
        builder.append(this.renderKeyword(visibility.toString())).append(" ");
    }

    private void renderModality(@NotNull Modality modality, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MODALITY)) {
            return;
        }
        String keyword = modality.name().toLowerCase();
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private void renderInner(boolean isInner, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.INNER)) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private void renderModalityForCallable(@NotNull CallableMemberDescriptor callable, @NotNull StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || callable.getModality() != Modality.FINAL) {
            if (DescriptorRendererImpl.overridesSomething(callable) && this.overrideRenderingPolicy == DescriptorRenderer.OverrideRenderingPolicy.RENDER_OVERRIDE && callable.getModality() == Modality.OPEN) {
                return;
            }
            this.renderModality(callable.getModality(), builder);
        }
    }

    private static boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    private void renderOverride(@NotNull CallableMemberDescriptor callableMember, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.OVERRIDE)) {
            return;
        }
        if (DescriptorRendererImpl.overridesSomething(callableMember) && this.overrideRenderingPolicy != DescriptorRenderer.OverrideRenderingPolicy.RENDER_OPEN) {
            builder.append("override ");
            if (this.verbose) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MEMBER_KIND)) {
            return;
        }
        if (this.verbose && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            builder.append("/*").append(callableMember.getKind().name().toLowerCase()).append("*/ ");
        }
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), stringBuilder);
        if (this.withDefinedIn) {
            this.appendDefinedIn(declarationDescriptor, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void renderTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull StringBuilder builder, boolean topLevel) {
        String variance;
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.verbose) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        if (!(variance = typeParameter.getVariance().getLabel()).isEmpty()) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderName(typeParameter, builder);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            JetType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!((Object)KotlinBuiltIns.getInstance().getDefaultBound()).equals(upperBound)) {
                builder.append(" : ").append(this.renderType(upperBound));
            }
        } else if (topLevel) {
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (((Object)upperBound).equals(KotlinBuiltIns.getInstance().getDefaultBound())) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                builder.append(this.renderType(upperBound));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private void renderTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder, boolean withSpace) {
        if (this.withoutTypeParameters) {
            return;
        }
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            Iterator<TypeParameterDescriptor> iterator2 = typeParameters.iterator();
            while (iterator2.hasNext()) {
                TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
                this.renderTypeParameter(typeParameterDescriptor, builder, false);
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private void renderFunction(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        if (!this.startFromName) {
            this.renderAnnotations(function, builder);
            this.renderVisibility(function.getVisibility(), builder);
            this.renderModalityForCallable(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            builder.append(this.renderKeyword("fun")).append(" ");
            this.renderTypeParameters(function.getTypeParameters(), builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder);
        this.renderValueParameters(function, builder);
        this.renderReceiverAfterName(function, builder);
        JetType returnType = function.getReturnType();
        if (this.unitReturnType || returnType == null || !KotlinBuiltIns.isUnit(returnType)) {
            builder.append(": ").append(returnType == null ? "[NULL]" : this.escape(this.renderType(returnType)));
        }
        this.renderWhereSuffix(function.getTypeParameters(), builder);
    }

    private void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.receiverAfterName) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            builder.append(" on ").append(this.escape(this.renderType(receiver.getType())));
        }
    }

    private void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            JetType type2 = receiver.getType();
            String result = this.escape(this.renderType(type2));
            if (this.shouldRenderAsPrettyFunctionType(type2) && !TypeUtils.isNullableType(type2)) {
                result = "(" + result + ")";
            }
            builder.append(result).append(".");
        }
    }

    private void renderConstructor(@NotNull ConstructorDescriptor constructor2, @NotNull StringBuilder builder) {
        this.renderAnnotations(constructor2, builder);
        this.renderVisibility(constructor2.getVisibility(), builder);
        this.renderMemberKind(constructor2, builder);
        builder.append(this.renderKeyword("constructor"));
        if (this.secondaryConstructorsAsPrimary) {
            ClassDescriptor classDescriptor = constructor2.getContainingDeclaration();
            builder.append(" ");
            this.renderName(classDescriptor, builder);
            this.renderTypeParameters(classDescriptor.getTypeConstructor().getParameters(), builder, false);
        }
        this.renderValueParameters(constructor2, builder);
        if (this.secondaryConstructorsAsPrimary) {
            this.renderWhereSuffix(constructor2.getTypeParameters(), builder);
        }
    }

    private void renderWhereSuffix(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder) {
        if (this.withoutTypeParameters) {
            return;
        }
        ArrayList<String> upperBoundStrings = new ArrayList<String>(0);
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (typeParameter.getUpperBounds().size() <= 1) continue;
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (!first) {
                    upperBoundStrings.add(this.renderName(typeParameter.getName()) + " : " + this.escape(this.renderType(upperBound)));
                }
                first = false;
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            builder.append(UtilsPackage.join(upperBoundStrings, ", "));
        }
    }

    @Override
    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderValueParameters(functionDescriptor, stringBuilder);
        return stringBuilder.toString();
    }

    private void renderValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        boolean includeNames = !this.withoutFunctionParameterNames && (this.includeSynthesizedParameterNames || !function.hasSynthesizedParameterNames());
        this.handler.appendBeforeValueParameters(function, builder);
        for (ValueParameterDescriptor parameter : function.getValueParameters()) {
            this.handler.appendBeforeValueParameter(parameter, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.handler.appendAfterValueParameter(parameter, builder);
        }
        this.handler.appendAfterValueParameters(function, builder);
    }

    private void renderValueParameter(@NotNull ValueParameterDescriptor valueParameter, boolean includeName, @NotNull StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.verbose) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        this.renderAnnotations(valueParameter, builder);
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.renderDefaultValues && (this.debugMode ? valueParameter.declaresDefaultValue() : valueParameter.hasDefaultValue()) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private void renderValVarPrefix(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder) {
        builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
    }

    private void renderVariable(@NotNull VariableDescriptor variable, boolean includeName, @NotNull StringBuilder builder, boolean topLevel) {
        JetType typeToRender;
        JetType realType = variable.getType();
        JetType varargElementType = variable instanceof ValueParameterDescriptor ? ((ValueParameterDescriptor)variable).getVarargElementType() : null;
        JetType jetType = typeToRender = varargElementType != null ? varargElementType : realType;
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.startFromName) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder);
            builder.append(": ");
        }
        builder.append(this.escape(this.renderType(typeToRender)));
        this.renderInitializer(variable, builder);
        if (this.verbose && varargElementType != null) {
            builder.append(" /*").append(this.escape(this.renderType(realType))).append("*/");
        }
    }

    private void renderProperty(@NotNull PropertyDescriptor property, @NotNull StringBuilder builder) {
        if (!this.startFromName) {
            this.renderAnnotations(property, builder);
            this.renderVisibility(property.getVisibility(), builder);
            this.renderModalityForCallable(property, builder);
            this.renderOverride(property, builder);
            this.renderMemberKind(property, builder);
            this.renderValVarPrefix(property, builder);
            this.renderTypeParameters(property.getTypeParameters(), builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder);
        builder.append(": ").append(this.escape(this.renderType(property.getType())));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        this.renderWhereSuffix(property.getTypeParameters(), builder);
    }

    private void renderInitializer(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder) {
        CompileTimeConstant<?> initializer;
        if (this.includePropertyConstant && (initializer = variable.getCompileTimeInitializer()) != null) {
            builder.append(" = ").append(this.escape(this.renderConstant(initializer)));
        }
    }

    private void renderClass(@NotNull ClassDescriptor klass, @NotNull StringBuilder builder) {
        ConstructorDescriptor primaryConstructor2;
        if (!this.startFromName) {
            this.renderAnnotations(klass, builder);
            this.renderVisibility(klass.getVisibility(), builder);
            if (!(klass.getKind() == ClassKind.TRAIT && klass.getModality() == Modality.ABSTRACT || klass.getKind().isSingleton() && klass.getModality() == Modality.FINAL)) {
                this.renderModality(klass.getModality(), builder);
            }
            this.renderInner(klass.isInner(), builder);
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.startFromName) {
                DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        List<TypeParameterDescriptor> typeParameters = klass.getTypeConstructor().getParameters();
        this.renderTypeParameters(typeParameters, builder, false);
        if (!klass.getKind().isSingleton() && this.classWithPrimaryConstructor && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            this.renderValueParameters(primaryConstructor2, builder);
        }
        this.renderSuperTypes(klass, builder);
        this.renderWhereSuffix(typeParameters, builder);
    }

    private void renderSuperTypes(@NotNull ClassDescriptor klass, @NotNull StringBuilder builder) {
        Collection<JetType> supertypes2;
        if (this.withoutSuperTypes) {
            return;
        }
        if (!(klass.equals(KotlinBuiltIns.getInstance().getNothing()) || (supertypes2 = klass.getTypeConstructor().getSupertypes()).isEmpty() || supertypes2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next()))) {
            DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            builder.append(": ");
            Iterator<JetType> iterator2 = supertypes2.iterator();
            while (iterator2.hasNext()) {
                JetType supertype = iterator2.next();
                builder.append(this.renderType(supertype));
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
        }
    }

    private void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRendererImpl.getClassKindPrefix(klass)));
    }

    @NotNull
    public static String getClassKindPrefix(@NotNull ClassDescriptor klass) {
        if (klass.isCompanionObject()) {
            return "companion object";
        }
        switch (klass.getKind()) {
            case CLASS: {
                return "class";
            }
            case TRAIT: {
                return "trait";
            }
            case ENUM_CLASS: {
                return "enum class";
            }
            case OBJECT: {
                return "object";
            }
            case ANNOTATION_CLASS: {
                return "annotation class";
            }
            case ENUM_ENTRY: {
                return "enum entry";
            }
        }
        throw new IllegalStateException("unknown class kind: " + (Object)((Object)klass.getKind()));
    }

    private void renderModuleOrScript(@NotNull DeclarationDescriptor moduleOrScript, @NotNull StringBuilder builder) {
        this.renderName(moduleOrScript, builder);
    }

    private void renderPackageView(@NotNull PackageViewDescriptor packageView, @NotNull StringBuilder builder) {
        builder.append(this.renderKeyword("package")).append(" ");
        builder.append(this.renderFqName(packageView.getFqName()));
        if (this.debugMode) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder);
        }
    }

    private void renderPackageFragment(@NotNull PackageFragmentDescriptor fragment, @NotNull StringBuilder builder) {
        builder.append(this.renderKeyword("package-fragment")).append(" ");
        builder.append(this.renderFqName(fragment.getFqName()));
        if (this.debugMode) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder);
        }
    }

    private class RenderDeclarationDescriptorVisitor
    extends DeclarationDescriptorVisitorEmptyBodies<Void, StringBuilder> {
        private RenderDeclarationDescriptorVisitor() {
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
            return null;
        }

        @Override
        public Void visitVariableDescriptor(VariableDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderVariable(descriptor2, true, builder, true);
            return null;
        }

        @Override
        public Void visitPropertyDescriptor(PropertyDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
            return null;
        }

        @Override
        public Void visitFunctionDescriptor(FunctionDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
            return null;
        }

        @Override
        public Void visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor2, StringBuilder data2) {
            throw new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public Void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
            return null;
        }

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
            return null;
        }

        @Override
        public Void visitPackageFragmentDescriptor(PackageFragmentDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
            return null;
        }

        @Override
        public Void visitPackageViewDescriptor(PackageViewDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
            return null;
        }

        @Override
        public Void visitModuleDeclaration(ModuleDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(descriptor2, builder);
            return null;
        }

        @Override
        public Void visitScriptDescriptor(ScriptDescriptor scriptDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(scriptDescriptor, builder);
            return null;
        }

        @Override
        public Void visitClassDescriptor(ClassDescriptor descriptor2, StringBuilder builder) {
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
            return null;
        }
    }
}

