/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.di;

import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.java.components.ExternalAnnotationResolver;
import org.jetbrains.kotlin.load.java.components.ExternalSignatureResolver;
import org.jetbrains.kotlin.load.java.components.JavaResolverCache;
import org.jetbrains.kotlin.load.java.components.MethodSignatureChecker;
import org.jetbrains.kotlin.load.java.components.RuntimeErrorReporter;
import org.jetbrains.kotlin.load.java.components.RuntimeSourceElementFactory;
import org.jetbrains.kotlin.load.java.components.SamConversionResolver;
import org.jetbrains.kotlin.load.java.lazy.GlobalJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaPackageFragmentProvider;
import org.jetbrains.kotlin.load.java.lazy.SingleModuleClassResolver;
import org.jetbrains.kotlin.load.java.reflect.ReflectJavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaPropertyInitializerEvaluator;
import org.jetbrains.kotlin.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import org.jetbrains.kotlin.load.kotlin.DeserializationComponentsForJava;
import org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.kotlin.load.kotlin.JavaClassDataFinder;
import org.jetbrains.kotlin.load.kotlin.reflect.ReflectKotlinClassFinder;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolver;
import org.jetbrains.kotlin.storage.StorageManager;

public class InjectorForRuntimeDescriptorLoader {
    private final ClassLoader classLoader;
    private final ModuleDescriptor moduleDescriptor;
    private final StorageManager storageManager;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final DeserializationComponentsForJava deserializationComponentsForJava;
    private final ExternalSignatureResolver externalSignatureResolver;
    private final MethodSignatureChecker methodSignatureChecker;
    private final JavaResolverCache javaResolverCache;
    private final ExternalAnnotationResolver externalAnnotationResolver;
    private final JavaPropertyInitializerEvaluator javaPropertyInitializerEvaluator;
    private final SamConversionResolver samConversionResolver;
    private final RuntimeErrorReporter runtimeErrorReporter;
    private final RuntimeSourceElementFactory runtimeSourceElementFactory;
    private final SingleModuleClassResolver singleModuleClassResolver;
    private final ReflectJavaClassFinder reflectJavaClassFinder;
    private final ReflectKotlinClassFinder reflectKotlinClassFinder;
    private final LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider;
    private final GlobalJavaResolverContext globalJavaResolverContext;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;
    private final ReflectionTypes reflectionTypes;
    private final JavaClassDataFinder javaClassDataFinder;
    private final BinaryClassAnnotationAndConstantLoaderImpl binaryClassAnnotationAndConstantLoader;

    public InjectorForRuntimeDescriptorLoader(@NotNull ClassLoader classLoader, @NotNull ModuleDescriptor moduleDescriptor, @NotNull StorageManager storageManager) {
        this.classLoader = classLoader;
        this.moduleDescriptor = moduleDescriptor;
        this.storageManager = storageManager;
        this.reflectJavaClassFinder = new ReflectJavaClassFinder(classLoader);
        this.reflectKotlinClassFinder = new ReflectKotlinClassFinder(classLoader);
        this.runtimeErrorReporter = RuntimeErrorReporter.INSTANCE$;
        this.deserializedDescriptorResolver = new DeserializedDescriptorResolver(this.runtimeErrorReporter);
        this.externalAnnotationResolver = ExternalAnnotationResolver.EMPTY;
        this.externalSignatureResolver = ExternalSignatureResolver.DO_NOTHING;
        this.methodSignatureChecker = MethodSignatureChecker.DO_NOTHING;
        this.javaResolverCache = JavaResolverCache.EMPTY;
        this.javaPropertyInitializerEvaluator = JavaPropertyInitializerEvaluator.DO_NOTHING;
        this.samConversionResolver = SamConversionResolver.EMPTY;
        this.runtimeSourceElementFactory = RuntimeSourceElementFactory.INSTANCE$;
        this.singleModuleClassResolver = new SingleModuleClassResolver();
        this.globalJavaResolverContext = new GlobalJavaResolverContext(storageManager, this.reflectJavaClassFinder, this.reflectKotlinClassFinder, this.deserializedDescriptorResolver, this.externalAnnotationResolver, this.externalSignatureResolver, this.runtimeErrorReporter, this.methodSignatureChecker, this.javaResolverCache, this.javaPropertyInitializerEvaluator, this.samConversionResolver, this.runtimeSourceElementFactory, this.singleModuleClassResolver);
        this.reflectionTypes = new ReflectionTypes(this.getModuleDescriptor());
        this.lazyJavaPackageFragmentProvider = new LazyJavaPackageFragmentProvider(this.globalJavaResolverContext, this.getModuleDescriptor(), this.reflectionTypes);
        this.javaDescriptorResolver = new JavaDescriptorResolver(this.lazyJavaPackageFragmentProvider, this.getModuleDescriptor());
        this.javaClassDataFinder = new JavaClassDataFinder(this.reflectKotlinClassFinder, this.deserializedDescriptorResolver);
        this.binaryClassAnnotationAndConstantLoader = new BinaryClassAnnotationAndConstantLoaderImpl(this.getModuleDescriptor(), storageManager, this.reflectKotlinClassFinder, this.runtimeErrorReporter);
        this.deserializationComponentsForJava = new DeserializationComponentsForJava(storageManager, this.getModuleDescriptor(), this.javaClassDataFinder, this.binaryClassAnnotationAndConstantLoader, this.lazyJavaPackageFragmentProvider);
        this.singleModuleClassResolver.setResolver(this.javaDescriptorResolver);
        this.deserializedDescriptorResolver.setComponents(this.deserializationComponentsForJava);
    }

    @PreDestroy
    public void destroy() {
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public JavaDescriptorResolver getJavaDescriptorResolver() {
        return this.javaDescriptorResolver;
    }

    public DeserializationComponentsForJava getDeserializationComponentsForJava() {
        return this.deserializationComponentsForJava;
    }
}

