/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.JetType;

public class ArrayValue
extends CompileTimeConstant<List<CompileTimeConstant<?>>> {
    private final JetType type;

    public ArrayValue(@NotNull List<CompileTimeConstant<?>> value, @NotNull JetType type2, boolean canBeUsedInAnnotations, boolean usesVariableAsConstant) {
        super(value, canBeUsedInAnnotations, false, usesVariableAsConstant);
        assert (KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2)) : "Type should be an array, but was " + type2 + ": " + value;
        this.type = type2;
    }

    @Override
    @NotNull
    public List<CompileTimeConstant<?>> getValue() {
        List value = (List)super.getValue();
        assert (value != null) : "Guaranteed by constructor";
        return value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        return this.type;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitArrayValue(this, data2);
    }

    public String toString() {
        return ((List)this.value).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayValue that = (ArrayValue)o;
        if (this.value == null) {
            return that.value == null;
        }
        int i = 0;
        for (CompileTimeConstant thisObject : (List)this.value) {
            if (!thisObject.equals(((List)that.value).get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.value == null) {
            return hashCode;
        }
        for (CompileTimeConstant o : (List)this.value) {
            hashCode += o.hashCode();
        }
        return hashCode;
    }
}

