/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.utils.UtilsPackage;

public final class ClassData {
    private final NameResolver nameResolver;
    private final ProtoBuf.Class classProto;

    @NotNull
    public static ClassData read(@NotNull byte[] bytes, @NotNull ExtensionRegistryLite registry) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            NameResolver nameResolver = NameResolver.read(in);
            ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(in, registry);
            return new ClassData(nameResolver, classProto);
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    public ClassData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto) {
        this.nameResolver = nameResolver;
        this.classProto = classProto;
    }

    @NotNull
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public ProtoBuf.Class getClassProto() {
        return this.classProto;
    }
}

