/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.storage.NoLock;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.UtilsPackage;
import org.jetbrains.kotlin.utils.WrappedValues;

public class LockBasedStorageManager
implements StorageManager {
    public static final StorageManager NO_LOCKS = new LockBasedStorageManager("NO_LOCKS", ExceptionHandlingStrategy.THROW, NoLock.INSTANCE){

        @Override
        @NotNull
        protected <T> RecursionDetectedResult<T> recursionDetectedDefault() {
            return RecursionDetectedResult.fallThrough();
        }
    };
    protected final Lock lock;
    private final ExceptionHandlingStrategy exceptionHandlingStrategy;
    private final String debugText;

    @NotNull
    public static LockBasedStorageManager createWithExceptionHandling(@NotNull ExceptionHandlingStrategy exceptionHandlingStrategy) {
        return new LockBasedStorageManager(exceptionHandlingStrategy);
    }

    private LockBasedStorageManager(@NotNull String debugText, @NotNull ExceptionHandlingStrategy exceptionHandlingStrategy, @NotNull Lock lock) {
        this.lock = lock;
        this.exceptionHandlingStrategy = exceptionHandlingStrategy;
        this.debugText = debugText;
    }

    public LockBasedStorageManager() {
        this(LockBasedStorageManager.getPointOfConstruction(), ExceptionHandlingStrategy.THROW, new ReentrantLock());
    }

    protected LockBasedStorageManager(@NotNull ExceptionHandlingStrategy exceptionHandlingStrategy) {
        this(LockBasedStorageManager.getPointOfConstruction(), exceptionHandlingStrategy, new ReentrantLock());
    }

    private static String getPointOfConstruction() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length <= 3) {
            return "<unknown creating class>";
        }
        return trace[3].toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " (" + this.debugText + ")";
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute) {
        return this.createMemoizedFunction(compute, LockBasedStorageManager.<K>createConcurrentHashMap());
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map) {
        return new MapBasedMemoizedFunctionToNotNull<K, V>(map, compute);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute) {
        return this.createMemoizedFunctionWithNullableValues(compute, LockBasedStorageManager.<K>createConcurrentHashMap());
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map) {
        return new MapBasedMemoizedFunction<K, V>(map, compute);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable) {
        return new LockBasedNotNullLazyValue<T>(computable);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createRecursionTolerantLazyValue(@NotNull Function0<? extends T> computable, final @NotNull T onRecursiveCall) {
        return new LockBasedNotNullLazyValue<T>(computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                return RecursionDetectedResult.value(onRecursiveCall);
            }
        };
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, final Function1<? super Boolean, ? extends T> onRecursiveCall, final @NotNull Function1<? super T, ? extends Unit> postCompute) {
        return new LockBasedNotNullLazyValue<T>(computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                if (onRecursiveCall == null) {
                    return super.recursionDetected(firstTime);
                }
                return RecursionDetectedResult.value(onRecursiveCall.invoke((Object)firstTime));
            }

            @Override
            protected void postCompute(@NotNull T value) {
                postCompute.invoke(value);
            }
        };
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Function0<? extends T> computable) {
        return new LockBasedLazyValue<T>(computable);
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createRecursionTolerantNullableLazyValue(@NotNull Function0<? extends T> computable, final T onRecursiveCall) {
        return new LockBasedLazyValue<T>(computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                return RecursionDetectedResult.value(onRecursiveCall);
            }
        };
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, final @NotNull Function1<? super T, ? extends Unit> postCompute) {
        return new LockBasedLazyValue<T>(computable){

            @Override
            protected void postCompute(@Nullable T value) {
                postCompute.invoke(value);
            }
        };
    }

    @Override
    public <T> T compute(@NotNull Function0<? extends T> computable) {
        this.lock.lock();
        try {
            Object object = computable.invoke();
            return (T)object;
        }
        catch (Throwable throwable) {
            throw this.exceptionHandlingStrategy.handleException(throwable);
        }
        finally {
            this.lock.unlock();
        }
    }

    @NotNull
    private static <K> ConcurrentMap<K, Object> createConcurrentHashMap() {
        return new ConcurrentHashMap(3, 1.0f, 2);
    }

    @NotNull
    protected <T> RecursionDetectedResult<T> recursionDetectedDefault() {
        throw new IllegalStateException("Recursive call in a lazy value under " + this);
    }

    @NotNull
    public static LockBasedStorageManager createDelegatingWithSameLock(@NotNull LockBasedStorageManager base, @NotNull ExceptionHandlingStrategy newStrategy) {
        return new LockBasedStorageManager(LockBasedStorageManager.getPointOfConstruction(), newStrategy, base.lock);
    }

    private class MapBasedMemoizedFunctionToNotNull<K, V>
    extends MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNotNull<K, V> {
        public MapBasedMemoizedFunctionToNotNull(@NotNull ConcurrentMap<K, Object> map, Function1<? super K, ? extends V> compute) {
            super(map, compute);
        }

        @Override
        @NotNull
        public V invoke(K input) {
            Object result = super.invoke(input);
            assert (result != null) : "compute() returned null under " + LockBasedStorageManager.this;
            return result;
        }
    }

    private class MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNullable<K, V> {
        private final ConcurrentMap<K, Object> cache;
        private final Function1<? super K, ? extends V> compute;

        public MapBasedMemoizedFunction(@NotNull ConcurrentMap<K, Object> map, Function1<? super K, ? extends V> compute) {
            this.cache = map;
            this.compute = compute;
        }

        @Nullable
        public V invoke(K input) {
            Object value = this.cache.get(input);
            if (value != null && value != NotValue.COMPUTING) {
                return WrappedValues.unescapeExceptionOrNull(value);
            }
            LockBasedStorageManager.this.lock.lock();
            try {
                Object object;
                value = this.cache.get(input);
                assert (value != NotValue.COMPUTING) : "Recursion detected on input: " + input + " under " + LockBasedStorageManager.this;
                if (value != null) {
                    Object v = WrappedValues.unescapeExceptionOrNull(value);
                    return v;
                }
                AssertionError error = null;
                try {
                    this.cache.put(input, (Object)NotValue.COMPUTING);
                    Object typedValue = this.compute.invoke(input);
                    Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
                    if (oldValue != NotValue.COMPUTING) {
                        error = new AssertionError((Object)("Race condition detected on input " + input + ". Old value is " + oldValue + " under " + LockBasedStorageManager.this));
                        throw error;
                    }
                    object = typedValue;
                }
                catch (Throwable throwable) {
                    if (throwable == error) {
                        throw LockBasedStorageManager.this.exceptionHandlingStrategy.handleException(throwable);
                    }
                    Object oldValue = this.cache.put(input, WrappedValues.escapeThrowable(throwable));
                    assert (oldValue == NotValue.COMPUTING) : "Race condition detected on input " + input + ". Old value is " + oldValue + " under " + LockBasedStorageManager.this;
                    throw LockBasedStorageManager.this.exceptionHandlingStrategy.handleException(throwable);
                }
                return (V)object;
            }
            finally {
                LockBasedStorageManager.this.lock.unlock();
            }
        }

        @Override
        public boolean isComputed(K key) {
            Object value = this.cache.get(key);
            return value != null && value != NotValue.COMPUTING;
        }
    }

    private class LockBasedNotNullLazyValue<T>
    extends LockBasedLazyValue<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValue(Function0<? extends T> computable) {
            super(computable);
        }

        @Override
        @NotNull
        public T invoke() {
            Object result = super.invoke();
            assert (result != null) : "compute() returned null";
            return result;
        }
    }

    private class LockBasedLazyValue<T>
    implements NullableLazyValue<T> {
        private final Function0<? extends T> computable;
        @Nullable
        private volatile Object value = NotValue.NOT_COMPUTED;

        public LockBasedLazyValue(Function0<? extends T> computable) {
            this.computable = computable;
        }

        @Override
        public boolean isComputed() {
            return this.value != NotValue.NOT_COMPUTED && this.value != NotValue.COMPUTING;
        }

        public T invoke() {
            Object _value = this.value;
            if (!(_value instanceof NotValue)) {
                return (T)WrappedValues.unescapeThrowable(_value);
            }
            LockBasedStorageManager.this.lock.lock();
            try {
                Object object;
                RecursionDetectedResult<T> result;
                _value = this.value;
                if (!(_value instanceof NotValue)) {
                    Object v = WrappedValues.unescapeThrowable(_value);
                    return (T)v;
                }
                if (_value == NotValue.COMPUTING) {
                    this.value = NotValue.RECURSION_WAS_DETECTED;
                    result = this.recursionDetected(true);
                    if (!result.isFallThrough()) {
                        T t = result.getValue();
                        return t;
                    }
                }
                if (_value == NotValue.RECURSION_WAS_DETECTED && !(result = this.recursionDetected(false)).isFallThrough()) {
                    T t = result.getValue();
                    return t;
                }
                this.value = NotValue.COMPUTING;
                try {
                    Object typedValue;
                    this.value = typedValue = this.computable.invoke();
                    this.postCompute(typedValue);
                    object = typedValue;
                }
                catch (Throwable throwable) {
                    if (this.value == NotValue.COMPUTING) {
                        this.value = WrappedValues.escapeThrowable(throwable);
                    }
                    throw LockBasedStorageManager.this.exceptionHandlingStrategy.handleException(throwable);
                }
                return (T)object;
            }
            finally {
                LockBasedStorageManager.this.lock.unlock();
            }
        }

        @NotNull
        protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
            return LockBasedStorageManager.this.recursionDetectedDefault();
        }

        protected void postCompute(T value) {
        }
    }

    private static enum NotValue {
        NOT_COMPUTED,
        COMPUTING,
        RECURSION_WAS_DETECTED;

    }

    private static class RecursionDetectedResult<T> {
        private final T value;
        private final boolean fallThrough;

        @NotNull
        public static <T> RecursionDetectedResult<T> value(T value) {
            return new RecursionDetectedResult<T>(value, false);
        }

        @NotNull
        public static <T> RecursionDetectedResult<T> fallThrough() {
            return new RecursionDetectedResult<Object>(null, true);
        }

        private RecursionDetectedResult(T value, boolean fallThrough) {
            this.value = value;
            this.fallThrough = fallThrough;
        }

        public T getValue() {
            assert (!this.fallThrough) : "A value requested from FALL_THROUGH in " + this;
            return this.value;
        }

        public boolean isFallThrough() {
            return this.fallThrough;
        }

        public String toString() {
            return this.isFallThrough() ? "FALL_THROUGH" : String.valueOf(this.value);
        }
    }

    public static interface ExceptionHandlingStrategy {
        public static final ExceptionHandlingStrategy THROW = new ExceptionHandlingStrategy(){

            @Override
            @NotNull
            public RuntimeException handleException(@NotNull Throwable throwable) {
                throw UtilsPackage.rethrow(throwable);
            }
        };

        @NotNull
        public RuntimeException handleException(@NotNull Throwable var1);
    }
}

