/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class CommonSupertypes {
    @Nullable
    public static JetType commonSupertypeForNonDenotableTypes(@NotNull Collection<JetType> types) {
        JetType type2;
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1 && (type2 = types.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type2.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types);
    }

    @NotNull
    public static JetType commonSupertype(@NotNull Collection<JetType> types) {
        return CommonSupertypes.findCommonSupertype(types, 0, CommonSupertypes.maxDepth(types) + 3);
    }

    private static int maxDepth(@NotNull Collection<JetType> types) {
        int max = 0;
        for (JetType type2 : types) {
            int depth = CommonSupertypes.depth(type2);
            if (max >= depth) continue;
            max = depth;
        }
        return max;
    }

    private static int depth(@NotNull JetType type2) {
        return 1 + CommonSupertypes.maxDepth(KotlinPackage.map(type2.getArguments(), (Function1)new Function1<TypeProjection, JetType>(){

            public JetType invoke(TypeProjection projection) {
                if (projection.isStarProjection()) {
                    return KotlinBuiltIns.getInstance().getAnyType();
                }
                return projection.getType();
            }
        }));
    }

    @NotNull
    private static JetType findCommonSupertype(@NotNull Collection<JetType> types, int recursionDepth, int maxDepth) {
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types;
        boolean hasFlexible = false;
        ArrayList<JetType> upper = new ArrayList<JetType>(types.size());
        ArrayList<JetType> lower = new ArrayList<JetType>(types.size());
        LinkedHashSet<FlexibleTypeCapabilities> capabilities = new LinkedHashSet<FlexibleTypeCapabilities>();
        for (JetType type2 : types) {
            if (TypesPackage.isFlexible(type2)) {
                hasFlexible = true;
                Flexibility flexibility = TypesPackage.flexibility(type2);
                upper.add(flexibility.getUpperBound());
                lower.add(flexibility.getLowerBound());
                capabilities.add(flexibility.getExtraCapabilities());
                continue;
            }
            upper.add(type2);
            lower.add(type2);
        }
        if (!hasFlexible) {
            return CommonSupertypes.commonSuperTypeForInflexible(types, recursionDepth, maxDepth);
        }
        return DelegatingFlexibleType.create(CommonSupertypes.commonSuperTypeForInflexible(lower, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth), (FlexibleTypeCapabilities)KotlinPackage.single(capabilities));
    }

    @NotNull
    private static JetType commonSuperTypeForInflexible(@NotNull Collection<JetType> types, int recursionDepth, int maxDepth) {
        assert (!types.isEmpty());
        HashSet<JetType> typeSet = new HashSet<JetType>(types);
        JetType bestFit = TypesPackage.singleBestRepresentative(typeSet);
        if (bestFit != null) {
            return bestFit;
        }
        boolean nullable2 = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            JetType type2 = (JetType)iterator2.next();
            assert (type2 != null);
            assert (!TypesPackage.isFlexible(type2)) : "Flexible type " + type2 + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                iterator2.remove();
            }
            if (type2.isError()) {
                return ErrorUtils.createErrorType("Supertype of error type " + type2);
            }
            nullable2 |= type2.isMarkedNullable();
        }
        if (typeSet.isEmpty()) {
            return nullable2 ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
        }
        if (typeSet.size() == 1) {
            return TypeUtils.makeNullableIfNeeded((JetType)typeSet.iterator().next(), nullable2);
        }
        Map<TypeConstructor, Set<JetType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<JetType> merge = new HashSet<JetType>();
            for (Set<JetType> supertypes2 : commonSupertypes.values()) {
                merge.addAll(supertypes2);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types;
        Map.Entry<TypeConstructor, Set<JetType>> entry = commonSupertypes.entrySet().iterator().next();
        JetType result = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        return TypeUtils.makeNullableIfNeeded(result, nullable2);
    }

    @NotNull
    private static Map<TypeConstructor, Set<JetType>> computeCommonRawSupertypes(@NotNull Collection<JetType> types) {
        assert (!types.isEmpty());
        HashMap<TypeConstructor, Set<JetType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<JetType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (JetType type2 : types) {
            HashSet<TypeConstructor> visited = new HashSet<TypeConstructor>();
            order = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(type2, constructorToAllInstances, visited);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited;
                continue;
            }
            commonSuperclasses.retainAll(visited);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<JetType>> result = new HashMap<TypeConstructor, Set<JetType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result.put(superConstructor, (Set<JetType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        return result;
    }

    @NotNull
    private static JetType computeSupertypeProjections(@NotNull TypeConstructor constructor2, @NotNull Set<JetType> types, int recursionDepth, int maxDepth) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return types.iterator().next();
        }
        List<TypeParameterDescriptor> parameters2 = constructor2.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>();
        int parametersSize = parameters2.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters2.get(i);
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (JetType type2 : types) {
                typeProjections.add(type2.getArguments().get(i));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections, recursionDepth, maxDepth));
        }
        boolean nullable2 = false;
        for (JetType type3 : types) {
            nullable2 |= type3.isMarkedNullable();
        }
        ClassifierDescriptor declarationDescriptor = constructor2.getDeclarationDescriptor();
        JetScope newScope = declarationDescriptor instanceof ClassDescriptor ? ((ClassDescriptor)declarationDescriptor).getMemberScope(newProjections) : (declarationDescriptor instanceof TypeParameterDescriptor ? ((TypeParameterDescriptor)declarationDescriptor).getUpperBoundsAsType().getMemberScope() : ErrorUtils.createErrorScope("A scope for common supertype which is not a normal classifier", true));
        return new JetTypeImpl(Annotations.EMPTY, constructor2, nullable2, newProjections, newScope);
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        Variance projectionKind;
        TypeProjection singleBestProjection = TypesPackage.singleBestRepresentative(typeProjections);
        if (singleBestProjection != null) {
            return singleBestProjection;
        }
        if (recursionDepth >= maxDepth) {
            return new TypeProjectionImpl(Variance.OUT_VARIANCE, KotlinBuiltIns.getInstance().getNullableAnyType());
        }
        HashSet<JetType> ins = new HashSet<JetType>();
        HashSet<JetType> outs = new HashSet<JetType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind2 = projection.getProjectionKind();
            if (projectionKind2.getAllowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind2.getAllowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            return new TypeProjectionImpl(projectionKind, CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth));
        }
        if (ins != null) {
            JetType intersection = TypeUtils.intersect(JetTypeChecker.DEFAULT, ins);
            if (intersection == null) {
                return new TypeProjectionImpl(Variance.OUT_VARIANCE, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
            }
            Variance projectionKind3 = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            return new TypeProjectionImpl(projectionKind3, intersection);
        }
        projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        return new TypeProjectionImpl(projectionKind, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor2, @NotNull Set<TypeConstructor> markerSet) {
        markerSet.add(typeConstructor2);
        for (JetType type2 : typeConstructor2.getSupertypes()) {
            CommonSupertypes.markAll(type2.getConstructor(), markerSet);
        }
    }
}

