/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckerProcedureCallbacksImpl;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedureCallbacks;

public class TypeCheckingProcedure {
    private final TypeCheckingProcedureCallbacks constraints;

    @Nullable
    public static JetType findCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
        return TypeCheckingProcedure.findCorrespondingSupertype(subtype, supertype, new TypeCheckerProcedureCallbacksImpl());
    }

    @Nullable
    public static JetType findCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        TypeConstructor constructor2 = subtype.getConstructor();
        if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor2, supertype.getConstructor())) {
            return subtype;
        }
        for (JetType immediateSupertype : constructor2.getSupertypes()) {
            JetType correspondingSupertype = TypeCheckingProcedure.findCorrespondingSupertype(immediateSupertype, supertype, typeCheckingProcedureCallbacks);
            if (correspondingSupertype == null) continue;
            return TypeSubstitutor.create(subtype).safeSubstitute(correspondingSupertype, Variance.INVARIANT);
        }
        return null;
    }

    public static JetType getOutType(TypeParameterDescriptor parameter, TypeProjection argument) {
        boolean isOutProjected = argument.getProjectionKind() == Variance.IN_VARIANCE || parameter.getVariance() == Variance.IN_VARIANCE;
        return isOutProjected ? parameter.getUpperBoundsAsType() : argument.getType();
    }

    public static JetType getInType(@NotNull TypeParameterDescriptor parameter, @NotNull TypeProjection argument) {
        boolean isOutProjected = argument.getProjectionKind() == Variance.OUT_VARIANCE || parameter.getVariance() == Variance.OUT_VARIANCE;
        return isOutProjected ? DescriptorUtilPackage.getBuiltIns(parameter).getNothingType() : argument.getType();
    }

    public TypeCheckingProcedure(TypeCheckingProcedureCallbacks constraints) {
        this.constraints = constraints;
    }

    public boolean equalTypes(@NotNull JetType type1, @NotNull JetType type2) {
        TypeConstructor constructor2;
        if (TypesPackage.isFlexible(type1)) {
            if (TypesPackage.isFlexible(type2)) {
                return !type1.isError() && !type2.isError() && this.isSubtypeOf(type1, type2) && this.isSubtypeOf(type2, type1);
            }
            return this.heterogeneousEquivalence(type2, type1);
        }
        if (TypesPackage.isFlexible(type2)) {
            return this.heterogeneousEquivalence(type1, type2);
        }
        if (type1.isMarkedNullable() != type2.isMarkedNullable()) {
            return false;
        }
        if (type1.isMarkedNullable()) {
            return this.constraints.assertEqualTypes(TypeUtils.makeNotNullable(type1), TypeUtils.makeNotNullable(type2), this);
        }
        TypeConstructor constructor1 = type1.getConstructor();
        if (!this.constraints.assertEqualTypeConstructors(constructor1, constructor2 = type2.getConstructor())) {
            return false;
        }
        List<TypeProjection> type1Arguments = type1.getArguments();
        List<TypeProjection> type2Arguments = type2.getArguments();
        if (type1Arguments.size() != type2Arguments.size()) {
            return false;
        }
        for (int i = 0; i < type1Arguments.size(); ++i) {
            TypeParameterDescriptor typeParameter1 = constructor1.getParameters().get(i);
            TypeProjection typeProjection1 = type1Arguments.get(i);
            TypeParameterDescriptor typeParameter2 = constructor2.getParameters().get(i);
            TypeProjection typeProjection2 = type2Arguments.get(i);
            if (typeProjection1.isStarProjection() && typeProjection2.isStarProjection() || this.capture(typeProjection1, typeProjection2, typeParameter1)) continue;
            if (TypeCheckingProcedure.getEffectiveProjectionKind(typeParameter1, typeProjection1) != TypeCheckingProcedure.getEffectiveProjectionKind(typeParameter2, typeProjection2)) {
                return false;
            }
            if (this.constraints.assertEqualTypes(typeProjection1.getType(), typeProjection2.getType(), this)) continue;
            return false;
        }
        return true;
    }

    protected boolean heterogeneousEquivalence(JetType inflexibleType, JetType flexibleType) {
        assert (!TypesPackage.isFlexible(inflexibleType)) : "Only inflexible types are allowed here: " + inflexibleType;
        return this.isSubtypeOf(TypesPackage.flexibility(flexibleType).getLowerBound(), inflexibleType) && this.isSubtypeOf(inflexibleType, TypesPackage.flexibility(flexibleType).getUpperBound());
    }

    public static EnrichedProjectionKind getEffectiveProjectionKind(@NotNull TypeParameterDescriptor typeParameter, @NotNull TypeProjection typeArgument) {
        Variance a = typeParameter.getVariance();
        Variance b = typeArgument.getProjectionKind();
        if (b == Variance.INVARIANT) {
            Variance t = a;
            a = b;
            b = t;
        }
        if (a == Variance.IN_VARIANCE && b == Variance.OUT_VARIANCE) {
            return EnrichedProjectionKind.STAR;
        }
        if (a == Variance.OUT_VARIANCE && b == Variance.IN_VARIANCE) {
            return EnrichedProjectionKind.STAR;
        }
        return EnrichedProjectionKind.fromVariance(b);
    }

    public boolean isSubtypeOf(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (TypesPackage.sameTypeConstructors(subtype, supertype)) {
            return !subtype.isMarkedNullable() || supertype.isMarkedNullable();
        }
        JetType subtypeRepresentative = TypesPackage.getSubtypeRepresentative(subtype);
        JetType supertypeRepresentative = TypesPackage.getSupertypeRepresentative(supertype);
        if (subtypeRepresentative != subtype || supertypeRepresentative != supertype) {
            return this.isSubtypeOf(subtypeRepresentative, supertypeRepresentative);
        }
        return this.isSubtypeOfForRepresentatives(subtype, supertype);
    }

    private boolean isSubtypeOfForRepresentatives(JetType subtype, JetType supertype) {
        if (subtype.isError() || supertype.isError()) {
            return true;
        }
        if (!supertype.isMarkedNullable() && subtype.isMarkedNullable()) {
            return false;
        }
        subtype = TypeUtils.makeNotNullable(subtype);
        supertype = TypeUtils.makeNotNullable(supertype);
        if (KotlinBuiltIns.isNothingOrNullableNothing(subtype)) {
            return true;
        }
        JetType closestSupertype = TypeCheckingProcedure.findCorrespondingSupertype(subtype, supertype, this.constraints);
        if (closestSupertype == null) {
            return this.constraints.noCorrespondingSupertype(subtype, supertype);
        }
        return this.checkSubtypeForTheSameConstructor(closestSupertype, supertype);
    }

    private boolean checkSubtypeForTheSameConstructor(@NotNull JetType subtype, @NotNull JetType supertype) {
        TypeConstructor constructor2 = subtype.getConstructor();
        assert (this.constraints.assertEqualTypeConstructors(constructor2, supertype.getConstructor())) : constructor2 + " is not " + supertype.getConstructor();
        List<TypeProjection> subArguments = subtype.getArguments();
        List<TypeProjection> superArguments = supertype.getArguments();
        if (subArguments.size() != superArguments.size()) {
            return false;
        }
        List<TypeParameterDescriptor> parameters2 = constructor2.getParameters();
        for (int i = 0; i < parameters2.size(); ++i) {
            boolean argumentIsErrorType;
            TypeParameterDescriptor parameter = parameters2.get(i);
            TypeProjection superArgument = superArguments.get(i);
            if (superArgument.isStarProjection()) continue;
            JetType superIn = TypeCheckingProcedure.getInType(parameter, superArgument);
            JetType superOut = TypeCheckingProcedure.getOutType(parameter, superArgument);
            TypeProjection subArgument = subArguments.get(i);
            JetType subIn = TypeCheckingProcedure.getInType(parameter, subArgument);
            JetType subOut = TypeCheckingProcedure.getOutType(parameter, subArgument);
            if (this.capture(subArgument, superArgument, parameter)) continue;
            boolean bl = argumentIsErrorType = subArgument.getType().isError() || superArgument.getType().isError();
            if (!argumentIsErrorType && parameter.getVariance() == Variance.INVARIANT && subArgument.getProjectionKind() == Variance.INVARIANT && superArgument.getProjectionKind() == Variance.INVARIANT) {
                if (this.constraints.assertEqualTypes(subArgument.getType(), superArgument.getType(), this)) continue;
                return false;
            }
            if (!this.constraints.assertSubtype(subOut, superOut, this)) {
                return false;
            }
            if (superArgument.getProjectionKind() != Variance.OUT_VARIANCE) {
                if (this.constraints.assertSubtype(superIn, subIn, this)) continue;
                return false;
            }
            assert (KotlinBuiltIns.isNothing(superIn)) : "In component must be Nothing for out-projection";
        }
        return true;
    }

    private boolean capture(@NotNull TypeProjection firstProjection, @NotNull TypeProjection secondProjection, @NotNull TypeParameterDescriptor parameter) {
        if (parameter.getVariance() != Variance.INVARIANT) {
            return false;
        }
        if (firstProjection.getProjectionKind() == Variance.INVARIANT && secondProjection.getProjectionKind() != Variance.INVARIANT) {
            return this.constraints.capture(firstProjection.getType(), secondProjection);
        }
        if (firstProjection.getProjectionKind() != Variance.INVARIANT && secondProjection.getProjectionKind() == Variance.INVARIANT) {
            return this.constraints.capture(secondProjection.getType(), firstProjection);
        }
        return false;
    }

    public static enum EnrichedProjectionKind {
        IN,
        OUT,
        INV,
        STAR;


        @NotNull
        public static EnrichedProjectionKind fromVariance(@NotNull Variance variance) {
            switch (variance) {
                case INVARIANT: {
                    return INV;
                }
                case IN_VARIANCE: {
                    return IN;
                }
                case OUT_VARIANCE: {
                    return OUT;
                }
            }
            throw new IllegalStateException("Unknown variance");
        }
    }
}

