/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InternalPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartSet<T>
extends AbstractSet<T> {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final int ARRAY_THRESHOLD = 5;
    private Object data;
    private int size;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(SmartSet.class);
        Companion companion = Companion = new Companion(null);
        ARRAY_THRESHOLD = 5;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator2;
        if (this.size == 0) {
            iterator2 = KotlinPackage.emptySet().iterator();
        } else if (this.size == 1) {
            iterator2 = new SingletonIterator<Object>(this.data);
        } else if (this.size < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            iterator2 = InternalPackage.iterator((Object[])((Object[])object));
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableSet<T>");
            }
            iterator2 = ((Set)object).iterator();
        }
        if (iterator2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableIterator<T>");
        }
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(T e) {
        if (this.size == 0) {
            this.data = e;
        } else if (this.size == 1) {
            if (Intrinsics.areEqual((Object)this.data, e)) {
                return false;
            }
            this.data = new Object[]{this.data, e};
        } else if (this.size < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Cloneable cloneable;
            SmartSet smartSet;
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] arr = (Object[])object;
            if (KotlinPackage.contains((Object[])arr, e)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (this.size == SmartSet.Companion.getARRAY_THRESHOLD() - 1) {
                void $receiver;
                LinkedHashSet linkedHashSet = KotlinPackage.linkedSetOf((Object[])arr);
                SmartSet smartSet3 = smartSet2;
                LinkedHashSet $receiver2 = (LinkedHashSet)$receiver;
                $receiver2.add(e);
                void var6_10 = $receiver;
                smartSet = smartSet3;
                cloneable = (Cloneable)var6_10;
            } else {
                void var3_5;
                Object[] $receiver = Arrays.copyOf(arr, this.size + 1);
                SmartSet smartSet4 = smartSet2;
                Object[] $receiver3 = $receiver;
                $receiver3[$receiver3.length - 1] = e;
                void var6_11 = var3_5;
                smartSet = smartSet4;
                cloneable = (Cloneable)var6_11;
            }
            smartSet.data = cloneable;
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableSet<T>");
            }
            Set set = (Set)object;
            if (!set.add(e)) {
                return false;
            }
        }
        int n = this.size++;
        return true;
    }

    @Override
    public void clear() {
        this.data = null;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        boolean bl;
        if (this.size == 0) {
            bl = false;
        } else if (this.size == 1) {
            bl = Intrinsics.areEqual((Object)this.data, (Object)o);
        } else if (this.size < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            bl = KotlinPackage.contains((Object[])((Object[])object), (Object)o);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Set<T>");
            }
            bl = ((Set)object).contains(o);
        }
        return bl;
    }

    private SmartSet() {
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create(@NotNull Set<? extends T> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"set");
        return Companion.create(set);
    }

    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final int getARRAY_THRESHOLD() {
            return ARRAY_THRESHOLD;
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create(@NotNull Set<? extends T> set) {
            void var2_2;
            Intrinsics.checkParameterIsNotNull(set, (String)"set");
            SmartSet $receiver = new SmartSet(null);
            SmartSet $receiver2 = $receiver;
            $receiver2.addAll(set);
            return (SmartSet)var2_2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class SingletonIterator<T>
    implements Iterator<T> {
        public static final /* synthetic */ KClass $kotlinClass;
        private boolean hasNext;
        private final T element;

        static {
            $kotlinClass = Reflection.createKotlinClass(SingletonIterator.class);
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public SingletonIterator(T element) {
            this.element = element;
            this.hasNext = true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Mutating immutable collection");
        }
    }
}

