/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant$$TImpl;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final IntegerValueTypeConstructor typeConstructor;
    @NotNull
    private final JetTypeImpl unknownIntegerType;
    private final Number value;
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;

    static {
        $kotlinClass = Reflection.createKotlinClass(IntegerValueTypeConstant.class);
    }

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        ConstantValueFactory factory = new ConstantValueFactory(this.builtIns);
        JetType type2 = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type2) ? (IntegerValueConstant)factory.createIntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (IntegerValueConstant)factory.createByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (IntegerValueConstant)factory.createShortValue(this.value.shortValue()) : (IntegerValueConstant)factory.createLongValue(this.value.longValue())));
    }

    @NotNull
    public final JetTypeImpl getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final JetType getType(@NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        JetType jetType = TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"TypeUtils.getPrimitiveNu\u2026onstructor, expectedType)");
        return jetType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public IntegerValueTypeConstant(@NotNull Number value, @NotNull KotlinBuiltIns builtIns, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        this.value = value;
        this.builtIns = builtIns;
        this.parameters = parameters2;
        this.typeConstructor = new IntegerValueTypeConstructor(this.value.longValue(), this.builtIns);
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = this.typeConstructor;
        List list = KotlinPackage.emptyList();
        JetScope jetScope = ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor.toString() + ")", true);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetScope, (String)"ErrorUtils.createErrorSc\u2026r.toString() + \")\", true)");
        this.unknownIntegerType = JetTypeImpl.Companion.create(annotations2, typeConstructor2, false, list, jetScope);
    }

    @Override
    public boolean getIsError() {
        return CompileTimeConstant$$TImpl.getIsError(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant$$TImpl.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant$$TImpl.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean getIsPure() {
        return CompileTimeConstant$$TImpl.getIsPure(this);
    }

    @Override
    @NotNull
    public Number getValue(@NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        return (Number)CompileTimeConstant$$TImpl.getValue(this, expectedType);
    }
}

