/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.List;
import kotlin.KotlinPackage;
import kotlin.data;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataProvider;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassDeserializer {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Function1<? super ClassKey, ? extends ClassDescriptor> classes;
    private final DeserializationComponents components;

    static {
        $kotlinClass = Reflection.createKotlinClass(ClassDeserializer.class);
    }

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassDataProvider classDataProvider) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return (ClassDescriptor)this.classes.invoke((Object)new ClassKey(classId, classDataProvider));
    }

    @Nullable
    public static /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassDataProvider classDataProvider, int n) {
        if ((n & 2) != 0) {
            classDataProvider = null;
        }
        return classDeserializer.deserializeClass(classId, classDataProvider);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDescriptor createClass(ClassKey key) {
        DeserializationContext deserializationContext;
        ClassId classId = key.getClassId();
        ClassDescriptor classDescriptor = this.components.getFictitiousClassDescriptorFactory().createClass(classId);
        if (classDescriptor != null) {
            ClassDescriptor $receiver = classDescriptor;
            ClassDescriptor it = $receiver;
            return it;
        }
        ClassDataProvider classDataProvider = key.getClassDataProvider();
        if (classDataProvider == null) {
            classDataProvider = this.components.getClassDataFinder().findClassData(classId);
        }
        if (classDataProvider == null) {
            return null;
        }
        ClassDataProvider classDataProvider2 = classDataProvider;
        ClassData classData = classDataProvider2.getClassData();
        if (classId.isNestedClass()) {
            ClassId classId2 = classId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"classId.getOuterClassId()");
            ClassDescriptor classDescriptor2 = ClassDeserializer.deserializeClass$default(this, classId2, null, 2);
            if (!(classDescriptor2 instanceof DeserializedClassDescriptor)) {
                classDescriptor2 = null;
            }
            DeserializedClassDescriptor deserializedClassDescriptor = (DeserializedClassDescriptor)classDescriptor2;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            DeserializedClassDescriptor outerClass = deserializedClassDescriptor;
            Name name = classId.getShortClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classId.getShortClassName()");
            if (!outerClass.hasNestedClass(name)) {
                return null;
            }
            deserializationContext = outerClass.getC();
        } else {
            void value;
            PackageFragmentProvider packageFragmentProvider = this.components.getPackageFragmentProvider();
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.getPackageFqName()");
            List<PackageFragmentDescriptor> fragments2 = packageFragmentProvider.getPackageFragments(fqName2);
            boolean bl = fragments2.size() == 1;
            if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
                String message = "There should be exactly one package: " + fragments2 + ", class id is " + classId;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)KotlinPackage.single(fragments2);
            if (fragment instanceof DeserializedPackageFragment) {
                DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)fragment;
                Name name = classId.getShortClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classId.getShortClassName()");
                if (!deserializedPackageFragment.hasTopLevelClass(name)) {
                    return null;
                }
            }
            NameResolver nameResolver = classData.getNameResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver, (String)"classData.getNameResolver()");
            deserializationContext = this.components.createContext(fragment, nameResolver);
        }
        DeserializationContext outerContext = deserializationContext;
        ProtoBuf.Class clazz = classData.getClassProto();
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"classData.getClassProto()");
        NameResolver nameResolver = classData.getNameResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver, (String)"classData.getNameResolver()");
        return new DeserializedClassDescriptor(outerContext, clazz, nameResolver, classDataProvider2.getSourceElement());
    }

    public ClassDeserializer(@NotNull DeserializationComponents components) {
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        this.components = components;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(@NotNull ClassKey key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                return ClassDeserializer.access$createClass$0(this.this$0, key);
            }
            {
                this.this$0 = classDeserializer;
                super(1);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$createClass$0(ClassDeserializer $this, @NotNull ClassKey key) {
        return $this.createClass(key);
    }

    @data
    private static final class ClassKey {
        public static final /* synthetic */ KClass $kotlinClass;
        @Nullable
        private final ClassDataProvider classDataProvider;
        @NotNull
        private final ClassId classId;

        static {
            $kotlinClass = Reflection.createKotlinClass(ClassKey.class);
        }

        @Nullable
        public final ClassDataProvider getClassDataProvider() {
            return this.classDataProvider;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        public ClassKey(@NotNull ClassId classId, @Nullable ClassDataProvider classDataProvider) {
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            this.classId = classId;
            this.classDataProvider = classDataProvider;
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @NotNull
        public final ClassKey copy(@NotNull ClassId classId, @Nullable ClassDataProvider classDataProvider) {
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            return new ClassKey(classId, classDataProvider);
        }

        @NotNull
        public static /* synthetic */ ClassKey copy$default(ClassKey classKey, ClassId classId, ClassDataProvider classDataProvider, int n) {
            if ((n & 1) != 0) {
                classId = classKey.classId;
            }
            return classKey.copy(classId, classDataProvider);
        }

        public String toString() {
            return "ClassKey(classId=" + this.classId + ")";
        }

        public int hashCode() {
            ClassId classId = this.classId;
            return classId != null ? ((Object)classId).hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassKey)) break block3;
                    ClassKey classKey = (ClassKey)object;
                    if (!Intrinsics.areEqual((Object)this.classId, (Object)classKey.classId)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

