/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.SerializedResourcePaths;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<String, InputStream> loadResource;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        Object object = CollectionsKt.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(object instanceof DeserializedPackageFragment)) {
            object = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)object;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        Map<ClassId, ProtoBuf.Class> map2 = packageFragment.getClassIdToProto();
        if (map2 == null || (map2 = map2.get(classId)) == null) {
            ResourceLoadingClassDataFinder $receiver$iv = this;
            ResourceLoadingClassDataFinder $receiver = $receiver$iv;
            InputStream inputStream = (InputStream)$receiver.loadResource.invoke((Object)$receiver.serializedResourcePaths.getClassMetadataPath(classId));
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            map2 = ProtoBuf.Class.parseFrom(stream, $receiver.serializedResourcePaths.getExtensionRegistry());
        }
        Map<ClassId, ProtoBuf.Class> classProto = map2;
        NameResolver nameResolver = packageFragment.getNameResolver();
        Map<ClassId, ProtoBuf.Class> map3 = classProto;
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"classProto");
        return new ClassDataWithSource(new ClassData(nameResolver, (ProtoBuf.Class)((Object)map3)), null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentProvider, (String)"packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull((Object)serializedResourcePaths, (String)"serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, (String)"loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

