/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeTypeCapabilities
implements TypeCapabilities {
    private final TypeCapabilities first;
    private final TypeCapabilities second;

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, (String)"capabilityClass");
        T t = this.first.getCapability(capabilityClass);
        if (t == null) {
            t = this.second.getCapability(capabilityClass);
        }
        return t;
    }

    public CompositeTypeCapabilities(@NotNull TypeCapabilities first, @NotNull TypeCapabilities second) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
        this.first = first;
        this.second = second;
    }
}

