/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.platform;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE = new JavaToKotlinClassMap();
    private final Map<FqNameUnsafe, ClassId> javaToKotlin = new HashMap<FqNameUnsafe, ClassId>();
    private final Map<FqNameUnsafe, ClassId> kotlinToJava = new HashMap<FqNameUnsafe, ClassId>();
    private final Map<FqNameUnsafe, FqName> mutableToReadOnly = new HashMap<FqNameUnsafe, FqName>();
    private final Map<FqNameUnsafe, FqName> readOnlyToMutable = new HashMap<FqNameUnsafe, FqName>();

    private JavaToKotlinClassMap() {
        this.addTopLevel(Object.class, KotlinBuiltIns.FQ_NAMES.any);
        this.addTopLevel(String.class, KotlinBuiltIns.FQ_NAMES.string);
        this.addTopLevel(CharSequence.class, KotlinBuiltIns.FQ_NAMES.charSequence);
        this.addTopLevel(Throwable.class, KotlinBuiltIns.FQ_NAMES.throwable);
        this.addTopLevel(Cloneable.class, KotlinBuiltIns.FQ_NAMES.cloneable);
        this.addTopLevel(Number.class, KotlinBuiltIns.FQ_NAMES.number);
        this.addTopLevel(Comparable.class, KotlinBuiltIns.FQ_NAMES.comparable);
        this.addTopLevel(Enum.class, KotlinBuiltIns.FQ_NAMES._enum);
        this.addTopLevel(Annotation.class, KotlinBuiltIns.FQ_NAMES.annotation);
        this.addMutableReadOnlyPair(Iterable.class, ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable), KotlinBuiltIns.FQ_NAMES.mutableIterable);
        this.addMutableReadOnlyPair(Iterator.class, ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterator), KotlinBuiltIns.FQ_NAMES.mutableIterator);
        this.addMutableReadOnlyPair(Collection.class, ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.collection), KotlinBuiltIns.FQ_NAMES.mutableCollection);
        this.addMutableReadOnlyPair(List.class, ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.list), KotlinBuiltIns.FQ_NAMES.mutableList);
        this.addMutableReadOnlyPair(Set.class, ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.set), KotlinBuiltIns.FQ_NAMES.mutableSet);
        this.addMutableReadOnlyPair(ListIterator.class, ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.listIterator), KotlinBuiltIns.FQ_NAMES.mutableListIterator);
        ClassId mapClassId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map);
        this.addMutableReadOnlyPair(Map.class, mapClassId, KotlinBuiltIns.FQ_NAMES.mutableMap);
        this.addMutableReadOnlyPair(Map.Entry.class, mapClassId.createNestedClassId(KotlinBuiltIns.FQ_NAMES.mapEntry.shortName()), KotlinBuiltIns.FQ_NAMES.mutableMapEntry);
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            this.add(ClassId.topLevel(jvmType.getWrapperFqName()), ClassId.topLevel(KotlinBuiltIns.getPrimitiveFqName(jvmType.getPrimitiveType())));
        }
        for (ClassId classId : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId.getShortClassName().asString() + "CompanionObject")), classId.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT));
        }
        for (int i = 0; i < 23; ++i) {
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i)), KotlinBuiltIns.getFunctionClassId(i));
            FunctionClassDescriptor.Kind kFunction = FunctionClassDescriptor.Kind.KFunction;
            String kFun = kFunction.getPackageFqName() + "." + kFunction.getClassNamePrefix();
            this.addKotlinToJava(new FqName(kFun + i), ClassId.topLevel(new FqName(kFun)));
        }
        this.addKotlinToJava(KotlinBuiltIns.FQ_NAMES.nothing.toSafe(), JavaToKotlinClassMap.classId(Void.class));
    }

    @Nullable
    public ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(0);
        }
        return this.javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        ClassId kotlinClassId;
        if (fqName2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(1);
        }
        if (builtIns == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(2);
        }
        return (kotlinClassId = this.mapJavaToKotlin(fqName2)) != null ? builtIns.getBuiltInClassByFqName(kotlinClassId.asSingleFqName()) : null;
    }

    @Nullable
    public ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        if (kotlinFqName == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(3);
        }
        return this.kotlinToJava.get(kotlinFqName);
    }

    private void addMutableReadOnlyPair(@NotNull Class<?> javaClass, @NotNull ClassId kotlinReadOnlyClassId, @NotNull FqName kotlinMutableFqName) {
        if (javaClass == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(4);
        }
        if (kotlinReadOnlyClassId == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(5);
        }
        if (kotlinMutableFqName == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(6);
        }
        ClassId javaClassId = JavaToKotlinClassMap.classId(javaClass);
        this.add(javaClassId, kotlinReadOnlyClassId);
        this.addKotlinToJava(kotlinMutableFqName, javaClassId);
        FqName kotlinReadOnlyFqName = kotlinReadOnlyClassId.asSingleFqName();
        this.mutableToReadOnly.put(kotlinMutableFqName.toUnsafe(), kotlinReadOnlyFqName);
        this.readOnlyToMutable.put(kotlinReadOnlyFqName.toUnsafe(), kotlinMutableFqName);
    }

    private void add(@NotNull ClassId javaClassId, @NotNull ClassId kotlinClassId) {
        if (javaClassId == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(7);
        }
        if (kotlinClassId == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(8);
        }
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        this.addKotlinToJava(kotlinClassId.asSingleFqName(), javaClassId);
    }

    private void addTopLevel(@NotNull Class<?> javaClass, @NotNull FqNameUnsafe kotlinFqName) {
        if (javaClass == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(9);
        }
        if (kotlinFqName == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(10);
        }
        this.addTopLevel(javaClass, kotlinFqName.toSafe());
    }

    private void addTopLevel(@NotNull Class<?> javaClass, @NotNull FqName kotlinFqName) {
        if (javaClass == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(11);
        }
        if (kotlinFqName == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(12);
        }
        this.add(JavaToKotlinClassMap.classId(javaClass), ClassId.topLevel(kotlinFqName));
    }

    private void addJavaToKotlin(@NotNull ClassId javaClassId, @NotNull ClassId kotlinClassId) {
        if (javaClassId == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(13);
        }
        if (kotlinClassId == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(14);
        }
        this.javaToKotlin.put(javaClassId.asSingleFqName().toUnsafe(), kotlinClassId);
    }

    private void addKotlinToJava(@NotNull FqName kotlinFqNameUnsafe, @NotNull ClassId javaClassId) {
        if (kotlinFqNameUnsafe == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(15);
        }
        if (javaClassId == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(16);
        }
        this.kotlinToJava.put(kotlinFqNameUnsafe.toUnsafe(), javaClassId);
    }

    @NotNull
    private static ClassId classId(@NotNull Class<?> clazz) {
        if (clazz == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(17);
        }
        assert (!clazz.isPrimitive() && !clazz.isArray()) : "Invalid class: " + clazz;
        Class<?> outer = clazz.getDeclaringClass();
        ClassId classId = outer == null ? ClassId.topLevel(new FqName(clazz.getCanonicalName())) : JavaToKotlinClassMap.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
        if (classId == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(18);
        }
        return classId;
    }

    public boolean isJavaPlatformClass(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(19);
        }
        return this.mapJavaToKotlin(fqName2) != null;
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        ClassDescriptor kotlinAnalog;
        if (fqName2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(20);
        }
        if (builtIns == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(21);
        }
        if ((kotlinAnalog = this.mapJavaToKotlin(fqName2, builtIns)) == null) {
            Set<ClassDescriptor> set = Collections.emptySet();
            if (set == null) {
                JavaToKotlinClassMap.$$$reportNull$$$0(22);
            }
            return set;
        }
        FqName kotlinMutableAnalogFqName = this.readOnlyToMutable.get(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (kotlinMutableAnalogFqName == null) {
            Set<ClassDescriptor> set = Collections.singleton(kotlinAnalog);
            if (set == null) {
                JavaToKotlinClassMap.$$$reportNull$$$0(23);
            }
            return set;
        }
        List<ClassDescriptor> list = Arrays.asList(kotlinAnalog, builtIns.getBuiltInClassByFqName(kotlinMutableAnalogFqName));
        if (list == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(24);
        }
        return list;
    }

    public boolean isMutable(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(27);
        }
        return this.mutableToReadOnly.containsKey(DescriptorUtils.getFqName(mutable));
    }

    public boolean isMutable(@NotNull KotlinType type2) {
        ClassDescriptor classDescriptor;
        if (type2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(28);
        }
        return (classDescriptor = TypeUtils.getClassDescriptor(type2)) != null && this.isMutable(classDescriptor);
    }

    public boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(29);
        }
        return this.readOnlyToMutable.containsKey(DescriptorUtils.getFqName(readOnly));
    }

    public boolean isReadOnly(@NotNull KotlinType type2) {
        ClassDescriptor classDescriptor;
        if (type2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(30);
        }
        return (classDescriptor = TypeUtils.getClassDescriptor(type2)) != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(31);
        }
        ClassDescriptor classDescriptor = JavaToKotlinClassMap.convertToOppositeMutability(mutable, this.mutableToReadOnly, "mutable");
        if (classDescriptor == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(32);
        }
        return classDescriptor;
    }

    @NotNull
    private static ClassDescriptor convertToOppositeMutability(@NotNull ClassDescriptor descriptor2, @NotNull Map<FqNameUnsafe, FqName> map2, @NotNull String mutabilityKindName) {
        FqName oppositeClassFqName;
        if (descriptor2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(33);
        }
        if (map2 == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(34);
        }
        if (mutabilityKindName == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(35);
        }
        if ((oppositeClassFqName = map2.get(DescriptorUtils.getFqName(descriptor2))) == null) {
            throw new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        if (classDescriptor == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(36);
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(37);
        }
        ClassDescriptor classDescriptor = JavaToKotlinClassMap.convertToOppositeMutability(readOnly, this.readOnlyToMutable, "read-only");
        if (classDescriptor == null) {
            JavaToKotlinClassMap.$$$reportNull$$$0(38);
        }
        return classDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinFqName";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinReadOnlyClassId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinMutableFqName";
                break;
            }
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaClassId";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinClassId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinFqNameUnsafe";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutable";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readOnly";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutabilityKindName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "classId";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "mapPlatformClass";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMutableToReadOnly";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToOppositeMutability";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "convertReadOnlyToMutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapJavaToKotlin";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mapKotlinToJava";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addMutableReadOnlyPair";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTopLevel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addJavaToKotlin";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addKotlinToJava";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "classId";
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 36: 
            case 38: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isJavaPlatformClass";
                break;
            }
            case 20: 
            case 21: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "mapPlatformClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isMutable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isReadOnly";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "convertMutableToReadOnly";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "convertToOppositeMutability";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "convertReadOnlyToMutable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

